/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.cipher;

import com.wechat.pay.java.core.certificate.CertificateProvider;
import com.wechat.pay.java.core.cipher.Verifier;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVerifier
implements Verifier {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractVerifier.class);
    protected final CertificateProvider certificateProvider;
    protected final PublicKey publicKey;
    protected final String publicKeyId;
    protected final String algorithmName;

    protected AbstractVerifier(String algorithmName, CertificateProvider certificateProvider) {
        this.certificateProvider = Objects.requireNonNull(certificateProvider);
        this.algorithmName = Objects.requireNonNull(algorithmName);
        this.publicKey = null;
        this.publicKeyId = null;
    }

    protected AbstractVerifier(String algorithmName, PublicKey publicKey, String publicKeyId) {
        this.publicKey = Objects.requireNonNull(publicKey);
        this.publicKeyId = publicKeyId;
        this.algorithmName = Objects.requireNonNull(algorithmName);
        this.certificateProvider = null;
    }

    protected AbstractVerifier(String algorithmName, PublicKey publicKey, String publicKeyId, CertificateProvider certificateProvider) {
        this.publicKey = Objects.requireNonNull(publicKey);
        this.publicKeyId = publicKeyId;
        this.algorithmName = Objects.requireNonNull(algorithmName);
        this.certificateProvider = Objects.requireNonNull(certificateProvider);
    }

    protected boolean verify(X509Certificate certificate, String message, String signature) {
        try {
            Signature sign = Signature.getInstance(this.algorithmName);
            sign.initVerify(certificate);
            sign.update(message.getBytes(StandardCharsets.UTF_8));
            return sign.verify(Base64.getDecoder().decode(signature));
        }
        catch (SignatureException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("verify uses an illegal certificate.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("The current Java environment does not support " + this.algorithmName, e);
        }
    }

    private boolean verify(String message, String signature) {
        try {
            Signature sign = Signature.getInstance(this.algorithmName);
            sign.initVerify(this.publicKey);
            sign.update(message.getBytes(StandardCharsets.UTF_8));
            return sign.verify(Base64.getDecoder().decode(signature));
        }
        catch (SignatureException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("verify uses an illegal publickey.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException("The current Java environment does not support " + this.algorithmName, e);
        }
    }

    @Override
    public boolean verify(String serialNumber, String message, String signature) {
        if (this.publicKey != null) {
            if (serialNumber.equals(this.publicKeyId)) {
                return this.verify(message, signature);
            }
            if (this.certificateProvider == null) {
                logger.error("publicKeyId[{}] and serialNumber[{}] are not equal", (Object)this.publicKeyId, (Object)serialNumber);
                return false;
            }
        }
        Objects.requireNonNull(this.certificateProvider);
        X509Certificate certificate = this.certificateProvider.getCertificate(serialNumber);
        if (certificate == null) {
            logger.error("Verify the signature and get the WechatPay certificate or publicKey corresponding to serialNumber[{}] is empty.", (Object)serialNumber);
            return false;
        }
        return this.verify(certificate, message, signature);
    }
}

