/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.util;

import com.wechat.pay.java.core.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

public class PemUtil {
    private PemUtil() {
    }

    public static PrivateKey loadPrivateKeyFromString(String keyString) {
        try {
            keyString = keyString.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            return KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(keyString)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PrivateKey loadPrivateKeyFromString(String keyString, String algorithm, String provider) {
        try {
            keyString = keyString.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replaceAll("\\s+", "");
            return KeyFactory.getInstance(algorithm, provider).generatePrivate(new PKCS8EncodedKeySpec(Base64.getDecoder().decode(keyString)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (NoSuchProviderException | InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PublicKey loadPublicKeyFromString(String keyString) {
        try {
            keyString = keyString.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s+", "");
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.getDecoder().decode(keyString)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PrivateKey loadPrivateKeyFromPath(String keyPath) {
        return PemUtil.loadPrivateKeyFromString(PemUtil.readKeyStringFromPath(keyPath));
    }

    public static PrivateKey loadPrivateKeyFromPath(String keyPath, String algorithm, String provider) {
        return PemUtil.loadPrivateKeyFromString(PemUtil.readKeyStringFromPath(keyPath), algorithm, provider);
    }

    public static PublicKey loadPublicKeyFromPath(String keyPath) {
        return PemUtil.loadPublicKeyFromString(PemUtil.readKeyStringFromPath(keyPath));
    }

    private static String readKeyStringFromPath(String keyPath) {
        String string;
        FileInputStream inputStream = new FileInputStream(keyPath);
        try {
            string = IOUtil.toString(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return string;
    }

    public static X509Certificate loadX509FromStream(InputStream inputStream) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(inputStream);
        }
        catch (CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static X509Certificate loadX509FromStream(InputStream inputStream, String provider) {
        try {
            return (X509Certificate)CertificateFactory.getInstance("X.509", provider).generateCertificate(inputStream);
        }
        catch (NoSuchProviderException | CertificateException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static X509Certificate loadX509FromPath(String certificatePath) {
        X509Certificate x509Certificate;
        FileInputStream inputStream = new FileInputStream(certificatePath);
        try {
            x509Certificate = PemUtil.loadX509FromStream(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return x509Certificate;
    }

    public static X509Certificate loadX509FromPath(String certificatePath, String provider) {
        X509Certificate x509Certificate;
        FileInputStream inputStream = new FileInputStream(certificatePath);
        try {
            x509Certificate = PemUtil.loadX509FromStream(inputStream, provider);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return x509Certificate;
    }

    public static X509Certificate loadX509FromString(String certificateString) {
        X509Certificate x509Certificate;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateString.getBytes(StandardCharsets.UTF_8));
        try {
            x509Certificate = PemUtil.loadX509FromStream(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return x509Certificate;
    }

    public static X509Certificate loadX509FromString(String certificateString, String provider) {
        X509Certificate x509Certificate;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certificateString.getBytes(StandardCharsets.UTF_8));
        try {
            x509Certificate = PemUtil.loadX509FromStream(inputStream, provider);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return x509Certificate;
    }

    public static String getSerialNumber(X509Certificate certificate) {
        return certificate.getSerialNumber().toString(16).toUpperCase();
    }
}

