/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core;

import com.wechat.pay.java.core.util.PemUtil;
import java.security.PrivateKey;

public abstract class AbstractRSAConfigBuilder<T extends AbstractRSAConfigBuilder<T>> {
    protected String merchantId;
    protected PrivateKey privateKey;
    protected String merchantSerialNumber;

    protected abstract T self();

    public T merchantId(String merchantId) {
        this.merchantId = merchantId;
        return this.self();
    }

    public T privateKey(String privateKey) {
        this.privateKey = PemUtil.loadPrivateKeyFromString(privateKey);
        return this.self();
    }

    public T privateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        return this.self();
    }

    public T privateKeyFromPath(String keyPath) {
        this.privateKey = PemUtil.loadPrivateKeyFromPath(keyPath);
        return this.self();
    }

    public T merchantSerialNumber(String merchantSerialNumber) {
        this.merchantSerialNumber = merchantSerialNumber;
        return this.self();
    }
}

