/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.auth;

import com.wechat.pay.java.core.auth.Validator;
import com.wechat.pay.java.core.cipher.Verifier;
import com.wechat.pay.java.core.http.HttpHeaders;
import java.time.DateTimeException;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WechatPay2Validator
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(WechatPay2Validator.class);
    private static final int RESPONSE_EXPIRED_MINUTES = 5;
    private final Verifier verifier;

    public WechatPay2Validator(Verifier verifier) {
        this.verifier = Objects.requireNonNull(verifier);
    }

    @Override
    public <T> boolean validate(HttpHeaders responseHeaders, String responseBody) {
        String timestamp = responseHeaders.getHeader("Wechatpay-Timestamp");
        try {
            Instant responseTime = Instant.ofEpochSecond(Long.parseLong(timestamp));
            if (Duration.between(responseTime, Instant.now()).abs().toMinutes() >= 5L) {
                throw new IllegalArgumentException(String.format("Validate http response,timestamp[%s] of httpResponse is expires, request-id[%s]", timestamp, responseHeaders.getHeader("Request-ID")));
            }
        }
        catch (NumberFormatException | DateTimeException e) {
            throw new IllegalArgumentException(String.format("Validate http response,timestamp[%s] of httpResponse is invalid, request-id[%s]", timestamp, responseHeaders.getHeader("Request-ID")));
        }
        String message = timestamp + "\n" + responseHeaders.getHeader("Wechatpay-Nonce") + "\n" + (responseBody == null ? "" : responseBody) + "\n";
        logger.debug("Message for verifying signatures is[{}]", (Object)message);
        String serialNumber = responseHeaders.getHeader("Wechatpay-Serial");
        logger.debug("SerialNumber for verifying signatures is[{}]", (Object)serialNumber);
        String signature = responseHeaders.getHeader("Wechatpay-Signature");
        logger.debug("Signature for verifying signatures is[{}]", (Object)signature);
        return this.verifier.verify(serialNumber, message, signature);
    }

    @Override
    public <T> String getSerialNumber() {
        return this.verifier.getSerialNumber();
    }
}

