/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.wechat.pay.java.core.exception.HttpException;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.util.GsonUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;

public final class HttpRequest {
    private final HttpMethod httpMethod;
    private final URL url;
    private final URI uri;
    private final HttpHeaders headers;
    private final RequestBody body;

    private HttpRequest(HttpMethod httpMethod, URL url, URI uri, HttpHeaders headers, RequestBody body) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.uri = uri;
        this.headers = headers;
        this.body = body;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public URL getUrl() {
        return this.url;
    }

    public URI getUri() {
        return this.uri;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public String toString() {
        return GsonUtil.getGson().toJson((Object)this);
    }

    public static class Builder {
        HttpMethod httpMethod;
        private URL url;
        private HttpHeaders headers = new HttpHeaders();
        private RequestBody body;

        public Builder httpMethod(HttpMethod httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder url(URL url) {
            this.url = url;
            return this;
        }

        public Builder url(String urlString) {
            try {
                this.url = new URL(urlString);
                return this;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The urlString passed in when building httpRequest is invalid:" + urlString);
            }
        }

        public Builder headers(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.addHeader(name, value);
            return this;
        }

        public Builder body(RequestBody body) {
            this.body = body;
            return this;
        }

        public HttpRequest build() {
            try {
                return new HttpRequest(Objects.requireNonNull(this.httpMethod), Objects.requireNonNull(this.url), this.url.toURI(), this.headers == null ? new HttpHeaders() : this.headers, this.body);
            }
            catch (URISyntaxException e) {
                throw new HttpException(String.format("Parse url[%s] to uri failed.", this.url), (Throwable)e);
            }
        }
    }
}

