/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.http;

import com.google.gson.JsonSyntaxException;
import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.JsonResponseBody;
import com.wechat.pay.java.core.http.OriginalResponse;
import com.wechat.pay.java.core.http.ResponseBody;
import com.wechat.pay.java.core.util.GsonUtil;
import java.util.Objects;

public final class HttpResponse<T> {
    private final HttpRequest request;
    private final HttpHeaders headers;
    private final ResponseBody body;
    private final T serviceResponse;

    private HttpResponse(HttpRequest request, HttpHeaders headers, ResponseBody body, T serviceResponse) {
        this.request = request;
        this.headers = headers;
        this.body = body;
        this.serviceResponse = serviceResponse;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public ResponseBody getBody() {
        return this.body;
    }

    public T getServiceResponse() {
        return this.serviceResponse;
    }

    public String toString() {
        return GsonUtil.getGson().toJson((Object)this);
    }

    public static class Builder<T> {
        private OriginalResponse originalResponse;
        private Class<T> serviceResponseType;

        public Builder<T> originalResponse(OriginalResponse originalResponse) {
            this.originalResponse = originalResponse;
            return this;
        }

        public Builder<T> serviceResponseType(Class<T> serviceResponseType) {
            this.serviceResponseType = serviceResponseType;
            return this;
        }

        public HttpResponse<T> build() {
            Object serviceResponse;
            Objects.requireNonNull(this.originalResponse);
            if (this.originalResponse.getBody() == null || this.originalResponse.getBody().isEmpty() || this.serviceResponseType == null) {
                return new HttpResponse(this.originalResponse.getRequest(), this.originalResponse.getHeaders(), null, null);
            }
            JsonResponseBody body = new JsonResponseBody.Builder().body(this.originalResponse.getBody()).build();
            try {
                serviceResponse = GsonUtil.getGson().fromJson(this.originalResponse.getBody(), this.serviceResponseType);
            }
            catch (JsonSyntaxException e) {
                throw new MalformedMessageException(String.format("Invalid json response body[%s]", this.originalResponse.getBody()), e);
            }
            return new HttpResponse(this.originalResponse.getRequest(), this.originalResponse.getHeaders(), body, serviceResponse);
        }
    }
}

