/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public class IOUtil {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private IOUtil() {
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        return buffer.toByteArray();
    }

    public static String toString(InputStream inputStream) throws IOException {
        return new String(IOUtil.toByteArray(inputStream), StandardCharsets.UTF_8);
    }

    public static String loadStringFromPath(String path) throws IOException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            String string = IOUtil.toString(inputStream);
            return string;
        }
    }
}

