/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.nlp;

import com.xkzhangsan.time.calculator.DateTimeCalculatorUtil;
import com.xkzhangsan.time.converter.DateTimeConverterUtil;
import com.xkzhangsan.time.enums.MomentEnum;
import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.nlp.TextAnalysis;
import com.xkzhangsan.time.nlp.TimeContext;
import com.xkzhangsan.time.utils.CollectionUtil;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeNLP {
    private static Map<Integer, Object> TUNIT_MAP = new HashMap<Integer, Object>();
    private String timeExpression = null;
    private String timeNorm = "";
    private String timeNormFormat = "";
    private Date time;
    private Boolean isAllDayTime = true;
    private boolean isFirstTimeSolveContext = true;
    private TextAnalysis textAnalysis = null;
    private TimeContext timeContext = new TimeContext();
    private TimeContext timeContextOrigin = new TimeContext();

    public TimeNLP(String timeExpression, TextAnalysis textAnalysis) {
        this.timeExpression = timeExpression;
        this.textAnalysis = textAnalysis;
        this.timeNormalization();
    }

    public TimeNLP(String timeExpression, TextAnalysis textAnalysis, TimeContext timePoint) {
        this.timeExpression = timeExpression;
        this.textAnalysis = textAnalysis;
        this.timeContextOrigin = timePoint;
        this.timeNormalization();
    }

    public Date getTime() {
        return this.time;
    }

    private LocalDateTime normStandardTime() {
        LocalDateTime localDateTime = null;
        String rule = "\\d{4}-\\d{1,2}-\\d{1,2}( \\d{1,2}:\\d{1,2}(:\\d{1,2})?)?";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            try {
                localDateTime = DateTimeFormatterUtil.smartParseToLocalDateTime(this.timeExpression);
                int[] tunit = this.timeContext.getTunit();
                tunit[0] = localDateTime.getYear();
                tunit[1] = localDateTime.getMonthValue();
                tunit[2] = localDateTime.getDayOfMonth();
                if (localDateTime.getHour() > 0) {
                    tunit[3] = localDateTime.getHour();
                }
                if (localDateTime.getMinute() > 0) {
                    tunit[4] = localDateTime.getMinute();
                }
                if (localDateTime.getSecond() > 0) {
                    tunit[5] = localDateTime.getSecond();
                }
            }
            catch (Exception e) {
                System.out.println("normStandardTime error:" + e.getMessage());
            }
        }
        return localDateTime;
    }

    private void normYear() {
        String rule = "[0-9]{2}(?=\u5e74)";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[0] = Integer.parseInt(match.group());
            if (this.timeContext.getTunit()[0] >= 0 && this.timeContext.getTunit()[0] < 100) {
                if (this.timeContext.getTunit()[0] < 30) {
                    int[] nArray = this.timeContext.getTunit();
                    nArray[0] = nArray[0] + 2000;
                } else {
                    int[] nArray = this.timeContext.getTunit();
                    nArray[0] = nArray[0] + 1900;
                }
            }
        }
        if ((match = (pattern = Pattern.compile(rule = "[0-9]?[0-9]{3}(?=\u5e74)")).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[0] = Integer.parseInt(match.group());
        }
    }

    private void normMonth() {
        String rule = "((10)|(11)|(12)|([1-9]))(?=\u6708)";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[1] = Integer.parseInt(match.group());
            this.preferFuture(1);
        }
    }

    private void normMonthFuzzyDay() {
        String rule = "((10)|(11)|(12)|([1-9]))(\u6708|\\.|\\-)([0-3][0-9]|[1-9])";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            String matchStr = match.group();
            Pattern p = Pattern.compile("(\u6708|\\.|\\-)");
            Matcher m = p.matcher(matchStr);
            if (m.find()) {
                int splitIndex = m.start();
                String month = matchStr.substring(0, splitIndex);
                String date = matchStr.substring(splitIndex + 1);
                this.timeContext.getTunit()[1] = Integer.parseInt(month);
                this.timeContext.getTunit()[2] = Integer.parseInt(date);
                this.preferFuture(1);
            }
        }
    }

    private void normDay() {
        String rule = "((?<!\\d))([0-3][0-9]|[1-9])(?=(\u65e5|\u53f7))";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[2] = Integer.parseInt(match.group());
            this.preferFuture(2);
        }
    }

    private void normHour() {
        String rule = "(?<!(\u5468|\u661f\u671f))([0-2]?[0-9])(?=(\u70b9|\u65f6))";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[3] = Integer.parseInt(match.group());
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "\u51cc\u6668")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.day_break.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "\u65e9\u4e0a|\u65e9\u6668|\u65e9\u95f4|\u6668\u95f4|\u4eca\u65e9|\u660e\u65e9")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.early_morning.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "\u4e0a\u5348")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.morning.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "(\u4e2d\u5348)|(\u5348\u95f4)")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 10) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.noon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "(\u4e0b\u5348)|(\u5348\u540e)|(pm)|(PM)")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.afternoon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "\u665a\u4e0a|\u591c\u95f4|\u591c\u91cc|\u4eca\u665a|\u660e\u665a")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 1 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            } else if (this.timeContext.getTunit()[3] == 12) {
                this.timeContext.getTunit()[3] = 0;
            } else if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.night.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
    }

    private void normMinute() {
        String rule = "(\\d+(\u5206\u949f|\u5206|min)[\u4ee5\u4e4b]?[\u524d\u540e])";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            return;
        }
        rule = "([0-5]?[0-9](?=\u5206(?!\u949f)))|((?<=((?<!\u5c0f)[\u70b9\u65f6]))[0-5]?[0-9](?!\u523b))";
        pattern = Pattern.compile(rule);
        match = pattern.matcher(this.timeExpression);
        if (match.find() && !match.group().equals("")) {
            this.timeContext.getTunit()[4] = Integer.parseInt(match.group());
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=[\u70b9\u65f6])[1\u4e00]\u523b(?!\u949f)")).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[4] = 15;
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=[\u70b9\u65f6])\u534a")).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[4] = 30;
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=[\u70b9\u65f6])[3\u4e09]\u523b(?!\u949f)")).matcher(this.timeExpression)).find()) {
            this.timeContext.getTunit()[4] = 45;
            this.preferFuture(4);
            this.isAllDayTime = false;
        }
    }

    private void normSecond() {
        String rule = "(\\d+(\u79d2\u949f|\u79d2|sec)[\u4ee5\u4e4b]?[\u524d\u540e])";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            return;
        }
        rule = "([0-5]?[0-9](?=\u79d2))|((?<=\u5206)[0-5]?[0-9])";
        pattern = Pattern.compile(rule);
        match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            this.timeContext.getTunit()[5] = Integer.parseInt(match.group());
            this.isAllDayTime = false;
        }
    }

    private void normTotal() {
        String tmpTarget;
        String[] tmpParser;
        String rule = "(?<!(\u5468|\u661f\u671f))([0-2]?[0-9]):[0-5]?[0-9]:[0-5]?[0-9]";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split(":");
            this.timeContext.getTunit()[3] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[4] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[5] = Integer.parseInt(tmpParser[2]);
            this.preferFuture(3);
            this.isAllDayTime = false;
        } else {
            rule = "(?<!(\u5468|\u661f\u671f))([0-2]?[0-9]):[0-5]?[0-9]";
            pattern = Pattern.compile(rule);
            match = pattern.matcher(this.timeExpression);
            if (match.find()) {
                tmpParser = new String[2];
                tmpTarget = match.group();
                tmpParser = tmpTarget.split(":");
                this.timeContext.getTunit()[3] = Integer.parseInt(tmpParser[0]);
                this.timeContext.getTunit()[4] = Integer.parseInt(tmpParser[1]);
                this.preferFuture(3);
                this.isAllDayTime = false;
            }
        }
        rule = "(\u4e2d\u5348)|(\u5348\u95f4)";
        pattern = Pattern.compile(rule);
        match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 10) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.noon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "(\u4e0b\u5348)|(\u5348\u540e)|(pm)|(PM)")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.afternoon.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "\u665a")).matcher(this.timeExpression)).find()) {
            if (this.timeContext.getTunit()[3] >= 1 && this.timeContext.getTunit()[3] <= 11) {
                int[] nArray = this.timeContext.getTunit();
                nArray[3] = nArray[3] + 12;
            } else if (this.timeContext.getTunit()[3] == 12) {
                this.timeContext.getTunit()[3] = 0;
            }
            if (this.timeContext.getTunit()[3] == -1) {
                this.timeContext.getTunit()[3] = MomentEnum.night.getHourTime();
            }
            this.preferFuture(3);
            this.isAllDayTime = false;
        }
        if ((match = (pattern = Pattern.compile(rule = "[0-9]?[0-9]?[0-9]{2}-((10)|(11)|(12)|([1-9]))-((?<!\\d))([0-3][0-9]|[1-9])")).matcher(this.timeExpression)).find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split("-");
            this.timeContext.getTunit()[0] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[1] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[2] = Integer.parseInt(tmpParser[2]);
        }
        if ((match = (pattern = Pattern.compile(rule = "((10)|(11)|(12)|([1-9]))/((?<!\\d))([0-3][0-9]|[1-9])/[0-9]?[0-9]?[0-9]{2}")).matcher(this.timeExpression)).find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split("/");
            this.timeContext.getTunit()[1] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[2] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[0] = Integer.parseInt(tmpParser[2]);
        }
        if ((match = (pattern = Pattern.compile(rule = "[0-9]?[0-9]?[0-9]{2}\\.((10)|(11)|(12)|([1-9]))\\.((?<!\\d))([0-3][0-9]|[1-9])")).matcher(this.timeExpression)).find()) {
            tmpParser = new String[3];
            tmpTarget = match.group();
            tmpParser = tmpTarget.split("\\.");
            this.timeContext.getTunit()[0] = Integer.parseInt(tmpParser[0]);
            this.timeContext.getTunit()[1] = Integer.parseInt(tmpParser[1]);
            this.timeContext.getTunit()[2] = Integer.parseInt(tmpParser[2]);
        }
    }

    private void normBaseRelated() {
        int year;
        int month;
        int day;
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        int[] ini = new int[6];
        for (int i = 0; i < 6; ++i) {
            ini[i] = Integer.parseInt(timeGrid[i]);
        }
        LocalDateTime localDateTime = LocalDateTime.of(ini[0], ini[1], ini[2], ini[3], ini[4], ini[5]);
        boolean flag = false;
        String rule = "\\d+(?=\u5929[\u4ee5\u4e4b]?\u524d)";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            flag = true;
            day = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusDays(day);
        }
        if ((match = (pattern = Pattern.compile(rule = "\\d+(?=\u5929[\u4ee5\u4e4b]?\u540e)")).matcher(this.timeExpression)).find()) {
            flag = true;
            day = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusDays(day);
        }
        if ((match = (pattern = Pattern.compile(rule = "\\d+(?=(\u4e2a)?\u6708[\u4ee5\u4e4b]?\u524d)")).matcher(this.timeExpression)).find()) {
            flag = true;
            month = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusMonths(month);
        }
        if ((match = (pattern = Pattern.compile(rule = "\\d+(?=(\u4e2a)?\u6708[\u4ee5\u4e4b]?\u540e)")).matcher(this.timeExpression)).find()) {
            flag = true;
            month = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusMonths(month);
        }
        if ((match = (pattern = Pattern.compile(rule = "\\d+(?=\u5e74[\u4ee5\u4e4b]?\u524d)")).matcher(this.timeExpression)).find()) {
            flag = true;
            year = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusYears(year);
        }
        if ((match = (pattern = Pattern.compile(rule = "\\d+(?=\u5e74[\u4ee5\u4e4b]?\u540e)")).matcher(this.timeExpression)).find()) {
            flag = true;
            year = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusYears(year);
        }
        if (flag) {
            this.setUnitValues(localDateTime);
        }
    }

    private void normBaseTimeRelated() {
        int minute;
        Matcher matchSecondAfter;
        Matcher matchSecondBefore;
        int hour;
        Matcher matchMinuteAfter;
        Matcher matchMinuteBefore;
        int hour2;
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        int[] ini = new int[6];
        for (int i = 0; i < 6; ++i) {
            ini[i] = Integer.parseInt(timeGrid[i]);
        }
        LocalDateTime localDateTime = LocalDateTime.of(ini[0], ini[1], ini[2], ini[3], ini[4], ini[5]);
        boolean flag = false;
        String rule = "\\d+(?=\u4e2a?\u534a?(\u5c0f\u65f6|\u949f\u5934|h|H)[\u4ee5\u4e4b]?\u524d)";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            flag = true;
            hour2 = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusHours(hour2);
        }
        if ((match = (pattern = Pattern.compile(rule = "\\d+(?=\u4e2a?\u534a?(\u5c0f\u65f6|\u949f\u5934|h|H)[\u4ee5\u4e4b]?\u540e)")).matcher(this.timeExpression)).find()) {
            flag = true;
            hour2 = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusHours(hour2);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u534a\u4e2a?(\u5c0f\u65f6|\u949f\u5934)[\u4ee5\u4e4b]?\u524d")).matcher(this.timeExpression)).find()) {
            flag = true;
            localDateTime = localDateTime.minusMinutes(30L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u534a\u4e2a?(\u5c0f\u65f6|\u949f\u5934)[\u4ee5\u4e4b]?\u540e")).matcher(this.timeExpression)).find()) {
            flag = true;
            localDateTime = localDateTime.plusMinutes(30L);
        }
        if ((matchMinuteBefore = (pattern = Pattern.compile(rule = "\\d+(?=(\u5206\u949f|\u5206|min)[\u4ee5\u4e4b]?\u524d)")).matcher(this.timeExpression)).find()) {
            flag = true;
            int minute2 = Integer.parseInt(matchMinuteBefore.group());
            localDateTime = localDateTime.minusMinutes(minute2);
        }
        if ((matchMinuteAfter = (pattern = Pattern.compile(rule = "\\d+(?=(\u5206\u949f|\u5206|min)[\u4ee5\u4e4b]?\u540e)")).matcher(this.timeExpression)).find()) {
            flag = true;
            int minute3 = Integer.parseInt(matchMinuteAfter.group());
            localDateTime = localDateTime.plusMinutes(minute3);
        }
        if (matchMinuteBefore.find() && (match = (pattern = Pattern.compile(rule = "\\d+(?=\u4e2a?\u534a?(\u5c0f\u65f6|\u949f\u5934|h|H))")).matcher(this.timeExpression)).find()) {
            flag = true;
            hour = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusHours(hour);
        }
        if (matchMinuteAfter.find() && (match = (pattern = Pattern.compile(rule = "\\d+(?=\u4e2a?\u534a?(\u5c0f\u65f6|\u949f\u5934|h|H))")).matcher(this.timeExpression)).find()) {
            flag = true;
            hour = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusHours(hour);
        }
        if ((matchSecondBefore = (pattern = Pattern.compile(rule = "\\d+(?=(\u79d2\u949f|\u79d2|sec)[\u4ee5\u4e4b]?\u524d)")).matcher(this.timeExpression)).find()) {
            flag = true;
            int second = Integer.parseInt(matchSecondBefore.group());
            localDateTime = localDateTime.minusSeconds(second);
        }
        if ((matchSecondAfter = (pattern = Pattern.compile(rule = "\\d+(?=(\u79d2\u949f|\u79d2|sec)[\u4ee5\u4e4b]?\u540e)")).matcher(this.timeExpression)).find()) {
            flag = true;
            int second = Integer.parseInt(matchSecondAfter.group());
            localDateTime = localDateTime.plusSeconds(second);
        }
        if (matchSecondBefore.find() && (match = (pattern = Pattern.compile(rule = "\\d+(?=(\u5206\u949f|min))")).matcher(this.timeExpression)).find()) {
            flag = true;
            minute = Integer.parseInt(match.group());
            localDateTime = localDateTime.minusMinutes(minute);
        }
        if (matchSecondAfter.find() && (match = (pattern = Pattern.compile(rule = "\\d+(?=(\u5206\u949f|min))")).matcher(this.timeExpression)).find()) {
            flag = true;
            minute = Integer.parseInt(match.group());
            localDateTime = localDateTime.plusMinutes(minute);
        }
        if (flag) {
            this.setUnitValues(localDateTime);
        }
    }

    private void normCurRelated() {
        int week;
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getOldTimeBase().split("-");
        int[] ini = new int[6];
        for (int i = 0; i < 6; ++i) {
            ini[i] = Integer.parseInt(timeGrid[i]);
        }
        LocalDateTime localDateTime = LocalDateTime.of(ini[0], ini[1], ini[2], ini[3], ini[4], ini[5]);
        boolean[] flag = new boolean[]{false, false, false};
        String rule = "\u524d\u5e74";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(this.timeExpression);
        if (match.find()) {
            flag[0] = true;
            localDateTime = localDateTime.minusYears(-2L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u53bb\u5e74")).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.minusYears(-1L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u4eca\u5e74")).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.plusYears(0L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u660e\u5e74")).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.plusYears(1L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u540e\u5e74")).matcher(this.timeExpression)).find()) {
            flag[0] = true;
            localDateTime = localDateTime.plusYears(2L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u4e0a(\u4e2a)?\u6708")).matcher(this.timeExpression)).find()) {
            flag[1] = true;
            localDateTime = localDateTime.minusMonths(-1L);
        }
        if ((match = (pattern = Pattern.compile(rule = "(\u672c|\u8fd9\u4e2a)\u6708")).matcher(this.timeExpression)).find()) {
            flag[1] = true;
            localDateTime = localDateTime.plusMonths(0L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u4e0b(\u4e2a)?\u6708")).matcher(this.timeExpression)).find()) {
            flag[1] = true;
            localDateTime = localDateTime.plusMonths(1L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u5927\u524d\u5929")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.minusDays(-3L);
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<!\u5927)\u524d\u5929")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.minusDays(-2L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u6628")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.minusDays(-1L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u4eca(?!\u5e74)")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(0L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u660e(?!\u5e74)")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(1L);
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<!\u5927)\u540e\u5929")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(2L);
        }
        if ((match = (pattern = Pattern.compile(rule = "\u5927\u540e\u5929")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            localDateTime = localDateTime.plusDays(3L);
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=(\u4e0a\u4e0a(\u5468|\u661f\u671f)))[1-7]?")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.minusWeeks(2L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=((?<!\u4e0a)\u4e0a(\u5468|\u661f\u671f)))[1-7]?")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.minusWeeks(1L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=((?<!\u4e0b)\u4e0b(\u5468|\u661f\u671f)))[1-7]?")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.plusWeeks(1L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=(\u4e0b\u4e0b(\u5468|\u661f\u671f)))[1-7]?")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.plusWeeks(2L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
        }
        if ((match = (pattern = Pattern.compile(rule = "(?<=((?<!(\u4e0a|\u4e0b))(\u5468|\u661f\u671f)))[1-7]?")).matcher(this.timeExpression)).find()) {
            flag[2] = true;
            try {
                week = Integer.parseInt(match.group());
            }
            catch (NumberFormatException e) {
                week = 1;
            }
            localDateTime = localDateTime.plusWeeks(0L);
            localDateTime = DateTimeCalculatorUtil.withDayOfWeek(localDateTime, (long)week);
            localDateTime = this.preferFutureWeek(week, localDateTime);
        }
        String s = DateTimeFormatterUtil.format(localDateTime, "yyyy-MM-dd-HH-mm-ss");
        String[] timeFin = s.split("-");
        if (flag[0] || flag[1] || flag[2]) {
            this.timeContext.getTunit()[0] = Integer.parseInt(timeFin[0]);
        }
        if (flag[1] || flag[2]) {
            this.timeContext.getTunit()[1] = Integer.parseInt(timeFin[1]);
        }
        if (flag[2]) {
            this.timeContext.getTunit()[2] = Integer.parseInt(timeFin[2]);
        }
    }

    private LocalDateTime preferFutureWeek(int weekday, LocalDateTime localDateTime) {
        int curWeekday;
        if (!this.textAnalysis.isPreferFuture()) {
            return localDateTime;
        }
        int checkTimeIndex = 2;
        for (int i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] == -1) continue;
            return localDateTime;
        }
        LocalDateTime curDateTime = LocalDateTime.now();
        if (this.timeContextOrigin.getTimeBase() != null) {
            String[] ini = this.timeContextOrigin.getTimeBase().split("-");
            curDateTime = LocalDateTime.of((int)Integer.valueOf(ini[0]), Integer.valueOf(ini[1]), (int)Integer.valueOf(ini[2]), (int)Integer.valueOf(ini[3]), (int)Integer.valueOf(ini[4]), (int)Integer.valueOf(ini[5]));
        }
        if ((curWeekday = curDateTime.get(ChronoField.DAY_OF_WEEK)) < weekday) {
            return localDateTime;
        }
        return localDateTime.plusWeeks(1L);
    }

    private void modifyTimeBase() {
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        String s = "";
        s = this.timeContext.getTunit()[0] != -1 ? s + Integer.toString(this.timeContext.getTunit()[0]) : s + timeGrid[0];
        for (int i = 1; i < 6; ++i) {
            s = s + "-";
            s = this.timeContext.getTunit()[i] != -1 ? s + Integer.toString(this.timeContext.getTunit()[i]) : s + timeGrid[i];
        }
        this.timeContextOrigin.setTimeBase(s);
    }

    private void timeNormalization() {
        int tunitpointer;
        LocalDateTime localDateTime = this.normStandardTime();
        if (localDateTime == null) {
            this.normYear();
            this.normMonth();
            this.normDay();
            this.normMonthFuzzyDay();
            this.normBaseRelated();
            this.normBaseTimeRelated();
            this.normCurRelated();
            this.normHour();
            this.normMinute();
            this.normSecond();
            this.normTotal();
            this.modifyTimeBase();
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        }
        String[] timeGrid = new String[6];
        timeGrid = this.timeContextOrigin.getTimeBase().split("-");
        for (tunitpointer = 5; tunitpointer >= 0 && this.timeContext.getTunit()[tunitpointer] < 0; --tunitpointer) {
        }
        for (int i = 0; i < tunitpointer; ++i) {
            if (this.timeContext.getTunit()[i] >= 0) continue;
            this.timeContext.getTunit()[i] = Integer.parseInt(timeGrid[i]);
        }
        String[] resultTmp = new String[6];
        resultTmp[0] = String.valueOf(this.timeContext.getTunit()[0]);
        if (this.timeContext.getTunit()[0] >= 10 && this.timeContext.getTunit()[0] < 100) {
            resultTmp[0] = "19" + String.valueOf(this.timeContext.getTunit()[0]);
        }
        if (this.timeContext.getTunit()[0] > 0 && this.timeContext.getTunit()[0] < 10) {
            resultTmp[0] = "200" + String.valueOf(this.timeContext.getTunit()[0]);
        }
        for (int i = 1; i < 6; ++i) {
            resultTmp[i] = String.valueOf(this.timeContext.getTunit()[i]);
        }
        if (Integer.parseInt(resultTmp[0]) != -1) {
            this.timeNorm = this.timeNorm + resultTmp[0] + "\u5e74";
            localDateTime = localDateTime.withYear(Integer.valueOf(resultTmp[0]));
            if (Integer.parseInt(resultTmp[1]) != -1) {
                this.timeNorm = this.timeNorm + resultTmp[1] + "\u6708";
                localDateTime = localDateTime.withMonth(Integer.valueOf(resultTmp[1]));
                if (Integer.parseInt(resultTmp[2]) != -1) {
                    this.timeNorm = this.timeNorm + resultTmp[2] + "\u65e5";
                    localDateTime = localDateTime.withDayOfMonth(Integer.valueOf(resultTmp[2]));
                    if (Integer.parseInt(resultTmp[3]) != -1) {
                        this.timeNorm = this.timeNorm + resultTmp[3] + "\u65f6";
                        localDateTime = localDateTime.withHour(Integer.valueOf(resultTmp[3]));
                        if (Integer.parseInt(resultTmp[4]) != -1) {
                            this.timeNorm = this.timeNorm + resultTmp[4] + "\u5206";
                            localDateTime = localDateTime.withMinute(Integer.valueOf(resultTmp[4]));
                            if (Integer.parseInt(resultTmp[5]) != -1) {
                                this.timeNorm = this.timeNorm + resultTmp[5] + "\u79d2";
                                localDateTime = localDateTime.withSecond(Integer.valueOf(resultTmp[5]));
                            }
                        }
                    }
                }
            }
        }
        this.timeContextOrigin.setTunit((int[])this.timeContext.getTunit().clone());
        this.timeContext.setTimeBase(this.timeContextOrigin.getTimeBase());
        this.timeContext.setOldTimeBase(this.timeContextOrigin.getOldTimeBase());
        this.time = DateTimeConverterUtil.toDate(localDateTime);
        this.timeNormFormat = DateTimeFormatterUtil.format(localDateTime, DateTimeFormatterUtil.YYYY_MM_DD_HH_MM_SS_FMT);
    }

    public Boolean getIsAllDayTime() {
        return this.isAllDayTime;
    }

    public void setIsAllDayTime(Boolean isAllDayTime) {
        this.isAllDayTime = isAllDayTime;
    }

    public String toString() {
        return this.timeExpression + " ---> " + this.timeNormFormat;
    }

    private void preferFuture(int checkTimeIndex) {
        String rule;
        Pattern pattern;
        Matcher match;
        int i;
        for (i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] == -1) continue;
            return;
        }
        this.checkContextTime(checkTimeIndex);
        for (i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] == -1) continue;
            return;
        }
        if (!this.textAnalysis.isPreferFuture()) {
            return;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        if (this.timeContextOrigin.getTimeBase() != null) {
            String[] ini = this.timeContextOrigin.getTimeBase().split("-");
            localDateTime = LocalDateTime.of((int)Integer.valueOf(ini[0]), Integer.valueOf(ini[1]), (int)Integer.valueOf(ini[2]), (int)Integer.valueOf(ini[3]), (int)Integer.valueOf(ini[4]), (int)Integer.valueOf(ini[5]));
        }
        int curTime = localDateTime.get((TemporalField)TUNIT_MAP.get(checkTimeIndex));
        if (checkTimeIndex == 3 && this.timeContext.getTunit()[3] >= 0 && this.timeContext.getTunit()[3] <= 11 ? (match = (pattern = Pattern.compile(rule = "(\u4e0b\u5348)|(\u5348\u540e)|(pm)|(PM)")).matcher(this.timeExpression)).find() && curTime < this.timeContext.getTunit()[3] + 12 : curTime < this.timeContext.getTunit()[checkTimeIndex]) {
            return;
        }
        localDateTime = localDateTime.plus(1L, (TemporalUnit)TUNIT_MAP.get(checkTimeIndex - 1 + 10));
        for (int i2 = 0; i2 < checkTimeIndex; ++i2) {
            this.timeContext.getTunit()[i2] = localDateTime.get((TemporalField)TUNIT_MAP.get(i2));
        }
    }

    private void checkContextTime(int checkTimeIndex) {
        for (int i = 0; i < checkTimeIndex; ++i) {
            if (this.timeContext.getTunit()[i] != -1 || this.timeContextOrigin.getTunit()[i] == -1) continue;
            this.timeContext.getTunit()[i] = this.timeContextOrigin.getTunit()[i];
        }
        if (this.isFirstTimeSolveContext && checkTimeIndex == 3 && this.timeContextOrigin.getTunit()[checkTimeIndex] >= 12 && this.timeContext.getTunit()[checkTimeIndex] < 12) {
            int[] nArray = this.timeContext.getTunit();
            int n = checkTimeIndex;
            nArray[n] = nArray[n] + 12;
        }
        this.isFirstTimeSolveContext = false;
    }

    public static List<TimeNLP> filterTimeUnit(List<TimeNLP> timeNLPList) {
        if (CollectionUtil.isEmpty(timeNLPList)) {
            return timeNLPList;
        }
        ArrayList<TimeNLP> list = new ArrayList<TimeNLP>();
        for (TimeNLP t : timeNLPList) {
            if (t == null || t.getTime().getTime() == -28800000L) continue;
            list.add(t);
        }
        return list;
    }

    private void setUnitValues(LocalDateTime localDateTime) {
        String s = DateTimeFormatterUtil.format(localDateTime, "yyyy-MM-dd-HH-mm-ss");
        String[] timeFin = s.split("-");
        this.timeContext.getTunit()[0] = Integer.parseInt(timeFin[0]);
        this.timeContext.getTunit()[1] = Integer.parseInt(timeFin[1]);
        this.timeContext.getTunit()[2] = Integer.parseInt(timeFin[2]);
        this.timeContext.getTunit()[3] = Integer.parseInt(timeFin[3]);
        this.timeContext.getTunit()[4] = Integer.parseInt(timeFin[4]);
        this.timeContext.getTunit()[5] = Integer.parseInt(timeFin[5]);
    }

    public String getTimeExpression() {
        return this.timeExpression;
    }

    public void setTimeExpression(String timeExpression) {
        this.timeExpression = timeExpression;
    }

    public String getTimeNorm() {
        return this.timeNorm;
    }

    public void setTimeNorm(String timeNorm) {
        this.timeNorm = timeNorm;
    }

    public String getTimeNormFormat() {
        return this.timeNormFormat;
    }

    public void setTimeNormFormat(String timeNormFormat) {
        this.timeNormFormat = timeNormFormat;
    }

    public TimeContext getTimeContext() {
        return this.timeContext;
    }

    public void setTimeContext(TimeContext timeContext) {
        this.timeContext = timeContext;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    static {
        TUNIT_MAP.put(0, ChronoField.YEAR);
        TUNIT_MAP.put(1, ChronoField.MONTH_OF_YEAR);
        TUNIT_MAP.put(2, ChronoField.DAY_OF_MONTH);
        TUNIT_MAP.put(3, ChronoField.HOUR_OF_DAY);
        TUNIT_MAP.put(4, ChronoField.MINUTE_OF_HOUR);
        TUNIT_MAP.put(5, ChronoField.SECOND_OF_MINUTE);
        TUNIT_MAP.put(10, ChronoUnit.YEARS);
        TUNIT_MAP.put(11, ChronoUnit.MONTHS);
        TUNIT_MAP.put(12, ChronoUnit.DAYS);
        TUNIT_MAP.put(13, ChronoUnit.HOURS);
        TUNIT_MAP.put(14, ChronoUnit.MINUTES);
        TUNIT_MAP.put(15, ChronoUnit.SECONDS);
    }
}

