/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.nlp;

import com.xkzhangsan.time.formatter.DateTimeFormatterUtil;
import com.xkzhangsan.time.nlp.TextAnalysis;
import com.xkzhangsan.time.nlp.TextPreprocess;
import com.xkzhangsan.time.nlp.TimeContext;
import com.xkzhangsan.time.nlp.TimeNLP;
import com.xkzhangsan.time.utils.CollectionUtil;
import com.xkzhangsan.time.utils.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class TimeNLPUtil {
    private TimeNLPUtil() {
    }

    public static List<TimeNLP> parse(String text) {
        return TimeNLPUtil.parse(text, null);
    }

    public static List<TimeNLP> parse(String text, String timeBase) {
        if (StringUtil.isEmpty(text)) {
            return null;
        }
        if (StringUtil.isEmpty(text = TextPreprocess.preprocess(text))) {
            return null;
        }
        List<String> timeStrs = TextAnalysis.getInstance().analysis(text);
        if (CollectionUtil.isEmpty(timeStrs)) {
            return null;
        }
        ArrayList<TimeNLP> timeNLPList = new ArrayList<TimeNLP>(timeStrs.size());
        TimeContext timeContext = new TimeContext();
        if (StringUtil.isEmpty(timeBase)) {
            timeBase = DateTimeFormatterUtil.format(new Date(), "yyyy-MM-dd-HH-mm-ss");
        }
        String oldTimeBase = timeBase;
        timeContext.setTimeBase(timeBase);
        timeContext.setOldTimeBase(oldTimeBase);
        for (int j = 0; j < timeStrs.size() && !StringUtil.isEmpty(timeStrs.get(j)); ++j) {
            TimeNLP timeNLP = new TimeNLP(timeStrs.get(j), TextAnalysis.getInstance(), timeContext);
            timeNLPList.add(timeNLP);
            timeContext = timeNLP.getTimeContext();
        }
        List<TimeNLP> timeNLPListResult = TimeNLP.filterTimeUnit(timeNLPList);
        return timeNLPListResult;
    }
}

