/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RegexResourceUtil {
    public static Pattern readModel(String file) throws Exception {
        ObjectInputStream in = file.startsWith("jar:file") || file.startsWith("file:") ? new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new URL(file).openStream()))) : new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
        return RegexResourceUtil.readModel(in);
    }

    private static Pattern readModel(ObjectInputStream in) throws Exception {
        Pattern p = (Pattern)in.readObject();
        return Pattern.compile(p.pattern());
    }

    public static void writeModel(Object p, String path) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(path))));
        out.writeObject(p);
        out.close();
    }

    public static String[] matcher(Pattern pattern, String text) throws Exception {
        String[] result = new String[99];
        int index = 0;
        Matcher match = pattern.matcher(text);
        while (match.find()) {
            result[index] = match.group();
            ++index;
        }
        return result;
    }

    public static String matcher(String rule, String text) throws Exception {
        String result = "";
        Pattern pattern = Pattern.compile(rule);
        Matcher match = pattern.matcher(text);
        while (match.find()) {
            result = match.group();
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String filePath = RegexResourceUtil.class.getClassLoader().getResource("TimeRegex.Gzip").getFile();
        Pattern pattern = RegexResourceUtil.readModel(filePath);
        System.out.println(pattern.pattern());
        String[] result = RegexResourceUtil.matcher(pattern, "\u660e\u5929");
        System.out.println(result);
        System.out.println(RegexResourceUtil.matcher("\\d+(\u5206\u949f|\u5206|min)[\u4ee5\u4e4b]?[\u524d\u540e]", "10\u5206\u540e"));
    }
}

