/*
 * Decompiled with CFR 0.152.
 */
package com.github.xuejike.query.core.tool.lambda;

import com.github.xuejike.query.core.exception.LambdaQueryException;
import com.github.xuejike.query.core.tool.lambda.ClassUtils;
import com.github.xuejike.query.core.tool.lambda.FieldFunction;
import com.github.xuejike.query.core.tool.lambda.SerializationUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SerializedLambda
implements Serializable {
    private static final long serialVersionUID = 8025925345765570181L;
    private Class<?> capturingClass;
    private String functionalInterfaceClass;
    private String functionalInterfaceMethodName;
    private String functionalInterfaceMethodSignature;
    private String implClass;
    private String implMethodName;
    private String implMethodSignature;
    private int implMethodKind;
    private String instantiatedMethodType;
    private Object[] capturedArgs;
    private static final Pattern INSTANTIATED_METHOD_TYPE = Pattern.compile("\\(L(?<instantiatedMethodType>[\\S&&[^;)]]+);\\)L[\\S]+;");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SerializedLambda resolve(FieldFunction<?, ?> lambda) {
        if (!lambda.getClass().isSynthetic()) {
            throw new LambdaQueryException("\u8be5\u65b9\u6cd5\u4ec5\u80fd\u4f20\u5165 lambda \u8868\u8fbe\u5f0f\u4ea7\u751f\u7684\u5408\u6210\u7c7b", new Object[0]);
        }
        try (ObjectInputStream objIn = new ObjectInputStream(new ByteArrayInputStream(SerializationUtils.serialize(lambda))){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
                Class<?> clazz = super.resolveClass(objectStreamClass);
                return clazz == java.lang.invoke.SerializedLambda.class ? SerializedLambda.class : clazz;
            }
        };){
            SerializedLambda serializedLambda = (SerializedLambda)objIn.readObject();
            return serializedLambda;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new LambdaQueryException("This is impossible to happen", e);
        }
    }

    public String getFunctionalInterfaceClassName() {
        return this.normalName(this.functionalInterfaceClass);
    }

    public Class<?> getImplClass() {
        return ClassUtils.toClassConfident(this.getImplClassName());
    }

    public String getImplClassName() {
        return this.normalName(this.implClass);
    }

    public String getImplMethodName() {
        return this.implMethodName;
    }

    private String normalName(String name) {
        return name.replace('/', '.');
    }

    public Class getInstantiatedMethodType() {
        Matcher matcher = INSTANTIATED_METHOD_TYPE.matcher(this.instantiatedMethodType);
        if (matcher.find()) {
            return ClassUtils.toClassConfident(this.normalName(matcher.group("instantiatedMethodType")));
        }
        throw new LambdaQueryException(String.format("\u65e0\u6cd5\u4ece %s \u89e3\u6790\u8c03\u7528\u5b9e\u4f8b\u3002\u3002\u3002", this.instantiatedMethodType), new Object[0]);
    }

    public String toString() {
        return String.format("%s -> %s::%s", this.getFunctionalInterfaceClassName(), this.getImplClass().getSimpleName(), this.implMethodName);
    }
}

