/*
 * Decompiled with CFR 0.152.
 */
package com.github.ztq2016;

import com.github.ztq2016.SVN_INFO_KEY;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="info", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class SvnInfoProvider
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="maven.svn.lastCommit", defaultValue="lastCommit")
    private String lastCommit;
    @Parameter(property="maven.svn.branchName", defaultValue="branchName")
    private String branchName;
    @Parameter(property="maven.svn.lastCommitTime", defaultValue="lastCommitTime")
    private String lastCommitTime;
    @Parameter(property="maven.svn.lastCommitAuthor", defaultValue="lastCommitAuthor")
    private String lastCommitAuthor;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String absolutePath = this.project.getBasedir().getAbsolutePath();
        Map<String, String> map = this.getSvnInfoMap(absolutePath);
        this.project.getProperties().setProperty(this.lastCommit, map.get(SVN_INFO_KEY.Last_Changed_Rev.getKey()));
        String url = map.get(SVN_INFO_KEY.URL.getKey());
        String rootUrl = map.get(SVN_INFO_KEY.Repository_Root.getKey());
        String branch = url.replace(rootUrl, "");
        this.project.getProperties().setProperty(this.branchName, branch);
        this.project.getProperties().setProperty(this.lastCommitTime, map.get(SVN_INFO_KEY.Last_Changed_Date.getKey()));
        this.project.getProperties().setProperty(this.lastCommitAuthor, map.get(SVN_INFO_KEY.Last_Changed_Author.getKey()));
        this.getLog().info((CharSequence)"\u81ea\u5b9a\u4e49\u63d2\u4ef6\u8fd0\u884c\u5b8c\u6bd5.");
    }

    private Map<String, String> getSvnInfoMap(String absolutePath) {
        File file;
        String parentUrl;
        Map<String, String> map = null;
        if (!this.isSvnWorkCopy(absolutePath)) {
            this.getLog().debug((CharSequence)"\u5f53\u524d\u76ee\u5f55\u4e0d\u662f\u4e00\u4e2asvn\u4ed3\u5e93.");
        }
        if (!this.isSvnWorkCopy(parentUrl = (file = new File(absolutePath)).getParent())) {
            this.getLog().debug((CharSequence)"\u5f53\u524d\u76ee\u5f55\u7684\u7236\u76ee\u5f55\u4e0d\u662f\u4e00\u4e2asvn\u4ed3\u5e93.");
            return map;
        }
        Runtime runtime = Runtime.getRuntime();
        String svnInfoCommand = "svn info";
        this.getLog().debug((CharSequence)("svn\u4fe1\u606f\u7684\u83b7\u53d6\u4f4d\u7f6e:" + parentUrl));
        try {
            int i;
            Process exec = runtime.exec(svnInfoCommand, null, new File(parentUrl));
            int status = exec.waitFor();
            if (status != 0) {
                InputStream errorStream = exec.getErrorStream();
                Map<String, String> svnInfoMap = this.getSvnInfoFromInputStream(errorStream);
                this.getLog().debug((CharSequence)"svn\u4fe1\u606f\u83b7\u53d6\u5931\u8d25:");
            }
            if ((i = exec.exitValue()) == 0) {
                InputStream inputStream = exec.getInputStream();
                return this.getSvnInfoFromInputStream(inputStream);
            }
            InputStream errorStream = exec.getErrorStream();
            String errInfo = this.getErrInfo(errorStream);
            this.getLog().error((CharSequence)("svn\u547d\u4ee4\u8fd0\u884c\u9519\u8bef:" + errInfo));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return map;
    }

    private Map<String, String> getSvnInfoFromInputStream(InputStream inputStream) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        if (inputStream != null) {
            String line;
            inputStreamReader = new InputStreamReader(inputStream, this.getCharset());
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (StringUtils.isBlank((String)line)) continue;
                int i = line.indexOf(":");
                if (i == -1) {
                    this.getLog().info((CharSequence)("\u6ca1\u6709\u529e\u6cd5\u5904\u7406\u7684svn\u4fe1\u606f:" + line));
                    continue;
                }
                String key = line.substring(0, i);
                String value = line.substring(i + 1, line.length());
                map.put(key, value);
            }
        }
        this.close(bufferedReader);
        this.close(inputStreamReader);
        this.close(inputStream);
        return map;
    }

    private String getCharset() {
        String osName = System.getProperty("os.name").toLowerCase();
        this.getLog().debug((CharSequence)("\u5f53\u524d\u64cd\u4f5c\u7cfb\u7edf\u7c7b\u578b:" + osName));
        String charset = "utf-8";
        if (osName.indexOf("windows") >= 0) {
            charset = "GBK";
        }
        return charset;
    }

    private void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getErrInfo(InputStream errInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        InputStreamReader inputStreamReader = null;
        if (errInputStream != null) {
            String line;
            inputStreamReader = new InputStreamReader(errInputStream, this.getCharset());
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                if (StringUtils.isBlank((String)line)) continue;
                stringBuffer.append(line);
                stringBuffer.append(System.lineSeparator());
            }
        }
        this.close(bufferedReader);
        this.close(inputStreamReader);
        this.close(errInputStream);
        return stringBuffer.toString();
    }

    private boolean isSvnWorkCopy(String absolutePath) {
        File[] files;
        File file = new File(absolutePath);
        for (File subFile : files = file.listFiles()) {
            if (!subFile.getName().equals(".svn")) continue;
            return true;
        }
        return false;
    }
}

