/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.util.ArrayList;

public class AnalysisError {
    private String message;
    private String exceptionMessage;
    private String[] stackTrace;
    private String nestedExceptionMessage;
    private String[] nestedStackTrace;
    private final Throwable exception;

    public AnalysisError(String message) {
        this(message, null);
    }

    public AnalysisError(String message, Throwable exception) {
        this.message = message;
        this.exception = exception;
        if (exception != null) {
            this.exceptionMessage = exception.toString();
            this.stackTrace = this.getStackTraceAsStringArray(exception);
            Throwable initCause = exception.getCause();
            if (initCause != null) {
                this.nestedExceptionMessage = initCause.toString();
                this.nestedStackTrace = this.getStackTraceAsStringArray(initCause);
            }
        }
    }

    private String[] getStackTraceAsStringArray(Throwable exception) {
        StackTraceElement[] exceptionStackTrace = exception.getStackTrace();
        ArrayList<String> arr = new ArrayList<String>();
        for (StackTraceElement aExceptionStackTrace : exceptionStackTrace) {
            arr.add(aExceptionStackTrace.toString());
        }
        String[] tmp = arr.toArray(new String[arr.size()]);
        return tmp;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getNestedExceptionMessage() {
        return this.nestedExceptionMessage;
    }

    public void setStackTrace(String[] stackTraceList) {
        this.stackTrace = stackTraceList;
    }

    public String[] getStackTrace() {
        return this.stackTrace;
    }

    public String[] getNestedStackTrace() {
        return this.nestedStackTrace;
    }

    public Throwable getException() {
        return this.exception;
    }
}

