/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationVisitor;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.PackageMemberAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class MethodAnnotation
extends PackageMemberAnnotation {
    private static final long serialVersionUID = 1L;
    private static final boolean UGLY_METHODS = SystemProperties.getBoolean("ma.ugly");
    private static final String DEFAULT_ROLE = "METHOD_DEFAULT";
    private String methodName;
    private String methodSig;
    private String fullMethod;
    private boolean isStatic;
    public static final String METHOD_DANGEROUS_TARGET_ACTUAL_GUARANTEED_NULL = "METHOD_DANGEROUS_TARGET_ACTUAL_GUARANTEED_NULL";
    public static final String METHOD_DANGEROUS_TARGET = "METHOD_DANGEROUS_TARGET";
    public static final String METHOD_RETURN_VALUE_OF = "METHOD_RETURN_VALUE_OF";
    public static final String METHOD_SAFE_TARGET = "METHOD_SAFE_TARGET";
    public static final String METHOD_EQUALS_USED = "METHOD_EQUALS_USED";
    public static final String METHOD_CALLED = "METHOD_CALLED";
    public static final String METHOD_SUPERCLASS_CONSTRUCTOR = "METHOD_SUPERCLASS_CONSTRUCTOR";
    public static final String METHOD_CONSTRUCTOR = "METHOD_CONSTRUCTOR";
    public static final String METHOD_OVERRIDDEN = "METHOD_OVERRIDDEN";
    public static final String METHOD_DID_YOU_MEAN_TO_OVERRIDE = "METHOD_DID_YOU_MEAN_TO_OVERRIDE";
    private static final String ELEMENT_NAME = "Method";

    public MethodAnnotation(String className, String methodName, String methodSig, boolean isStatic) {
        super(className, DEFAULT_ROLE);
        this.methodName = methodName;
        if (methodSig.indexOf(".") >= 0) {
            assert (false) : "signatures should not be dotted: " + methodSig;
            methodSig = methodSig.replace('.', '/');
        }
        this.methodSig = methodSig;
        this.isStatic = isStatic;
        this.fullMethod = null;
        this.sourceLines = null;
    }

    public static MethodAnnotation fromVisitedMethod(PreorderVisitor visitor) {
        String className = visitor.getDottedClassName();
        MethodAnnotation result = new MethodAnnotation(className, visitor.getMethodName(), visitor.getMethodSig(), visitor.getMethod().isStatic());
        SourceLineAnnotation srcLines = SourceLineAnnotation.fromVisitedMethod(visitor);
        result.setSourceLines(srcLines);
        return result;
    }

    public static MethodAnnotation fromCalledMethod(DismantleBytecode visitor) {
        String className = visitor.getDottedClassConstantOperand();
        String methodName = visitor.getNameConstantOperand();
        String methodSig = visitor.getSigConstantOperand();
        return MethodAnnotation.fromCalledMethod(className, methodName, methodSig, visitor.getOpcode() == 184);
    }

    public static MethodAnnotation fromForeignMethod(String className, String methodName, String methodSig, int accessFlags) {
        className = ClassName.toDottedClassName(className);
        MethodAnnotation methodAnnotation = new MethodAnnotation(className, methodName, methodSig, (accessFlags & 8) != 0);
        SourceLineAnnotation sourceLines = SourceLineAnnotation.getSourceAnnotationForMethod(className, methodName, methodSig);
        methodAnnotation.setSourceLines(sourceLines);
        return methodAnnotation;
    }

    public static MethodAnnotation fromForeignMethod(String className, String methodName, String methodSig, boolean isStatic) {
        className = ClassName.toDottedClassName(className);
        MethodAnnotation methodAnnotation = new MethodAnnotation(className, methodName, methodSig, isStatic);
        SourceLineAnnotation sourceLines = SourceLineAnnotation.getSourceAnnotationForMethod(className, methodName, methodSig);
        methodAnnotation.setSourceLines(sourceLines);
        return methodAnnotation;
    }

    public static MethodAnnotation fromCalledMethod(String className, String methodName, String methodSig, boolean isStatic) {
        MethodAnnotation methodAnnotation = MethodAnnotation.fromForeignMethod(className, methodName, methodSig, isStatic);
        methodAnnotation.setDescription(METHOD_CALLED);
        return methodAnnotation;
    }

    public static MethodAnnotation fromXMethod(XMethod xmethod) {
        return MethodAnnotation.fromForeignMethod(xmethod.getClassName(), xmethod.getName(), xmethod.getSignature(), xmethod.isStatic());
    }

    public static BugAnnotation fromMethodDescriptor(MethodDescriptor methodDescriptor) {
        return MethodAnnotation.fromForeignMethod(methodDescriptor.getSlashedClassName(), methodDescriptor.getName(), methodDescriptor.getSignature(), methodDescriptor.isStatic());
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getJavaSourceMethodName() {
        if (this.methodName.equals("<clinit>")) {
            return "<static initializer>";
        }
        if (this.methodName.equals("<init>")) {
            String result = this.getClassName();
            int pos = Math.max(result.lastIndexOf(36), result.lastIndexOf(46));
            return this.className.substring(pos + 1);
        }
        return this.methodName;
    }

    public String getMethodSignature() {
        return this.methodSig;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public XMethod toXMethod() {
        return XFactory.createXMethod(this.className, this.methodName, this.methodSig, this.isStatic);
    }

    public void accept(BugAnnotationVisitor visitor) {
        visitor.visitMethodAnnotation(this);
    }

    protected String formatPackageMember(String key, ClassAnnotation primaryClass) {
        if (key.equals("")) {
            return UGLY_METHODS ? this.getUglyMethod() : this.getFullMethod(primaryClass);
        }
        if (key.equals("givenClass")) {
            if (this.methodName.equals("<init>")) {
                return "new " + MethodAnnotation.shorten(primaryClass.getPackageName(), this.className) + this.getSignatureInClass(primaryClass);
            }
            if (this.className.equals(primaryClass.getClassName())) {
                return this.getNameInClass(primaryClass);
            }
            return MethodAnnotation.shorten(primaryClass.getPackageName(), this.className) + "." + this.getNameInClass(primaryClass);
        }
        if (key.equals("name")) {
            return this.methodName;
        }
        if (key.equals("nameAndSignature")) {
            return this.getNameInClass(primaryClass);
        }
        if (key.equals("shortMethod")) {
            return this.className + "." + this.methodName + "(...)";
        }
        if (key.equals("hash")) {
            String tmp = this.getNameInClass(false, true, true);
            return this.className + "." + tmp;
        }
        if (key.equals("returnType")) {
            int i = this.methodSig.indexOf(41);
            String returnType = this.methodSig.substring(i + 1);
            String pkgName = primaryClass == null ? "" : primaryClass.getPackageName();
            SignatureConverter converter = new SignatureConverter(returnType);
            return MethodAnnotation.shorten(pkgName, converter.parseNext());
        }
        throw new IllegalArgumentException("unknown key " + key);
    }

    public String getNameInClass(ClassAnnotation primaryClass) {
        return this.getNameInClass(true, false, false, false);
    }

    public String getSignatureInClass(ClassAnnotation primaryClass) {
        return this.getNameInClass(true, false, false, true);
    }

    public String getNameInClass(boolean shortenPackages, boolean useJVMMethodName, boolean hash) {
        return this.getNameInClass(shortenPackages, useJVMMethodName, hash, false);
    }

    public String getNameInClass(boolean shortenPackages, boolean useJVMMethodName, boolean hash, boolean omitMethodName) {
        StringBuilder result = new StringBuilder();
        if (!omitMethodName) {
            if (useJVMMethodName) {
                result.append(this.getMethodName());
            } else {
                result.append(this.getJavaSourceMethodName());
            }
        }
        result.append('(');
        SignatureConverter converter = new SignatureConverter(this.methodSig);
        if (converter.getFirst() != '(') {
            throw new IllegalStateException("bad method signature " + this.methodSig);
        }
        converter.skip();
        boolean needsComma = false;
        while (converter.getFirst() != ')') {
            if (needsComma) {
                if (hash) {
                    result.append(",");
                } else {
                    result.append(", ");
                }
            }
            if (shortenPackages) {
                result.append(MethodAnnotation.removePackageName(converter.parseNext()));
            } else {
                result.append(converter.parseNext());
            }
            needsComma = true;
        }
        converter.skip();
        result.append(')');
        return result.toString();
    }

    public String getFullMethod(ClassAnnotation primaryClass) {
        if (this.fullMethod == null) {
            this.fullMethod = this.methodName.equals("<init>") ? "new " + this.stripJavaLang(this.className) + this.getSignatureInClass(primaryClass) : this.stripJavaLang(this.className) + "." + this.getNameInClass(primaryClass);
        }
        return this.fullMethod;
    }

    public String stripJavaLang(@DottedClassName String className) {
        if (className.startsWith("java.lang.")) {
            return className.substring(10);
        }
        return className;
    }

    private String getUglyMethod() {
        return this.className + "." + this.methodName + " : " + this.methodSig.replace('/', '.');
    }

    public int hashCode() {
        return this.className.hashCode() + this.methodName.hashCode() + this.methodSig.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodAnnotation)) {
            return false;
        }
        MethodAnnotation other = (MethodAnnotation)o;
        return this.className.equals(other.className) && this.methodName.equals(other.methodName) && this.methodSig.equals(other.methodSig);
    }

    public int compareTo(BugAnnotation o) {
        if (!(o instanceof MethodAnnotation)) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        MethodAnnotation other = (MethodAnnotation)o;
        int cmp = this.className.compareTo(other.className);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.methodName.compareTo(other.methodName);
        if (cmp != 0) {
            return cmp;
        }
        return this.methodSig.compareTo(other.methodSig);
    }

    public void writeXML(XMLOutput xmlOutput) throws IOException {
    }

    public void writeXML(XMLOutput xmlOutput, boolean addMessages, boolean isPrimary) throws IOException {
        String role;
        XMLAttributeList attributeList = new XMLAttributeList().addAttribute("classname", this.getClassName()).addAttribute("name", this.getMethodName()).addAttribute("signature", this.getMethodSignature()).addAttribute("isStatic", String.valueOf(this.isStatic()));
        if (isPrimary) {
            attributeList.addAttribute("primary", "true");
        }
        if (!(role = this.getDescription()).equals(DEFAULT_ROLE)) {
            attributeList.addAttribute("role", role);
        }
        if (this.sourceLines == null && !addMessages) {
            xmlOutput.openCloseTag(ELEMENT_NAME, attributeList);
        } else {
            xmlOutput.openTag(ELEMENT_NAME, attributeList);
            if (this.sourceLines != null) {
                this.sourceLines.writeXML(xmlOutput);
            }
            if (addMessages) {
                xmlOutput.openTag("Message");
                xmlOutput.writeText(this.toString());
                xmlOutput.closeTag("Message");
            }
            xmlOutput.closeTag(ELEMENT_NAME);
        }
    }

    public boolean isSignificant() {
        String role = this.getDescription();
        return !METHOD_DANGEROUS_TARGET.equals(role) && !METHOD_DANGEROUS_TARGET_ACTUAL_GUARANTEED_NULL.equals(role) && !METHOD_SAFE_TARGET.equals(role) && !METHOD_EQUALS_USED.equals(role);
    }
}

