/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.util.LaunchBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class TestDesktopIntegration
extends JPanel {
    private static String[] propertyNames = new String[]{"java.version", "java.vendor", "java.vendor.url", "java.home", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version", "java.class.path", "java.library.path", "java.io.tmpdir", "java.compiler", "java.ext.dirs", "os.name", "os.arch", "os.version", "file.separator", "path.separator", "line.separator", "user.name", "user.home", "user.dir"};
    JTextArea console = new JTextArea(24, 80);
    static URL url;
    PrintWriter writer = new PrintWriter(new ConsoleWriter());
    static final boolean SHOW_CONSOLE = false;
    static final boolean SHOW_FILE_CHOOSER = false;

    public static void main(String[] args) throws Exception {
        String u = SystemProperties.getProperty("findbugs.browserTestURL", "http://findbugs.sourceforge.net/");
        url = new URL(u);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestDesktopIntegration.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("FindBugs browser integration Test");
        frame.setDefaultCloseOperation(3);
        frame.add(new TestDesktopIntegration());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public TestDesktopIntegration() {
        this.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout());
        this.add((Component)top, "Center");
        this.add((Component)new JLabel("These buttons should view " + url), "North");
        if (LaunchBrowser.desktopFeasible()) {
            JButton desktop = new JButton("Use java.awt.Desktop");
            desktop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        TestDesktopIntegration.this.writer.println("Launch via desktop of " + url);
                        LaunchBrowser.viaDesktop(url.toURI());
                        TestDesktopIntegration.this.writer.println("Launch via desktop completed");
                    }
                    catch (Throwable e1) {
                        TestDesktopIntegration.this.writer.println("Launch via desktop failed");
                        e1.printStackTrace(TestDesktopIntegration.this.writer);
                    }
                    TestDesktopIntegration.this.writer.flush();
                }
            });
            top.add(desktop);
        }
        if (LaunchBrowser.webstartFeasible()) {
            JButton jnlp = new JButton("Use jnlp");
            jnlp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        TestDesktopIntegration.this.writer.println("Launch via jnlp of " + url);
                        LaunchBrowser.viaWebStart(url);
                        TestDesktopIntegration.this.writer.println("Launch via jnlp completed");
                    }
                    catch (Throwable e1) {
                        TestDesktopIntegration.this.writer.println("Launch via jnlp failed");
                        e1.printStackTrace(TestDesktopIntegration.this.writer);
                    }
                    TestDesktopIntegration.this.writer.flush();
                }
            });
            top.add(jnlp);
        }
        if (LaunchBrowser.launchFirefox) {
            JButton exec = new JButton("exec firefox");
            exec.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        TestDesktopIntegration.this.writer.println("Launch via exec firefox " + url);
                        Process p = LaunchBrowser.launchFirefox(url);
                        Thread.sleep(3000L);
                        int exitValue = p.exitValue();
                        TestDesktopIntegration.this.writer.println("Exit code: " + exitValue);
                        TestDesktopIntegration.this.writer.println("Launch via exec firefox completed");
                    }
                    catch (Throwable e1) {
                        TestDesktopIntegration.this.writer.println("Launch via exec firefox threw exception");
                        e1.printStackTrace(TestDesktopIntegration.this.writer);
                    }
                    TestDesktopIntegration.this.writer.flush();
                }
            });
            top.add(exec);
        }
    }

    class ConsoleWriter
    extends Writer {
        ConsoleWriter() {
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            TestDesktopIntegration.this.console.append(new String(cbuf, off, len));
        }
    }
}

