/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;

public abstract class AbstractDataflowTestDriver {
    protected boolean overrideIsForwards;
    protected static final Knob[] KNOB_LIST = new Knob[]{new Knob("ta.instanceof", 2), new Knob("inva.trackvalues", 6), new Knob("fnd.derefs", 5)};

    public void overrideIsForwards() {
        this.overrideIsForwards = true;
    }

    protected void configureAnalysisContext(AnalysisContext analysisContext) {
        boolean max = SystemProperties.getBoolean("dataflow.max");
        for (Knob knob : KNOB_LIST) {
            boolean enable = max || SystemProperties.getBoolean(knob.systemPropertyName);
            System.out.println("Setting " + knob.systemPropertyName + "=" + enable);
            analysisContext.setBoolProperty(knob.analysisProperty, enable);
        }
    }

    public static class Knob {
        public String systemPropertyName;
        public int analysisProperty;

        public Knob(String systemPropertyName, int analysisProperty) {
            this.systemPropertyName = systemPropertyName;
            this.analysisProperty = analysisProperty;
        }
    }
}

