/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.ca;

import edu.umd.cs.findbugs.ba.AbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.BlockOrder;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ReversePostOrder;
import edu.umd.cs.findbugs.ba.ca.Call;
import edu.umd.cs.findbugs.ba.ca.CallList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallListAnalysis
extends AbstractDataflowAnalysis<CallList> {
    private DepthFirstSearch dfs;
    private Map<InstructionHandle, Call> callMap;

    public CallListAnalysis(CFG cfg, DepthFirstSearch dfs, ConstantPoolGen cpg) {
        this.dfs = dfs;
        this.callMap = CallListAnalysis.buildCallMap(cfg, cpg);
    }

    private static Map<InstructionHandle, Call> buildCallMap(CFG cfg, ConstantPoolGen cpg) {
        HashMap<InstructionHandle, Call> callMap = new HashMap<InstructionHandle, Call>();
        Iterator<Location> i = cfg.locationIterator();
        while (i.hasNext()) {
            InstructionHandle handle = i.next().getHandle();
            Instruction ins = handle.getInstruction();
            if (!(ins instanceof InvokeInstruction)) continue;
            InvokeInstruction inv = (InvokeInstruction)ins;
            Call call = new Call(inv.getClassName(cpg), inv.getName(cpg), inv.getSignature(cpg));
            callMap.put(handle, call);
        }
        return callMap;
    }

    @Override
    public void initEntryFact(CallList fact) {
        fact.clear();
    }

    @Override
    public boolean isForwards() {
        return true;
    }

    @Override
    public BlockOrder getBlockOrder(CFG cfg) {
        return new ReversePostOrder(cfg, this.dfs);
    }

    @Override
    public void makeFactTop(CallList fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(CallList fact) {
        return fact.isTop();
    }

    @Override
    public CallList createFact() {
        return new CallList();
    }

    @Override
    public boolean same(CallList a, CallList b) {
        return a.equals(b);
    }

    @Override
    public void meetInto(CallList start, Edge edge, CallList result) throws DataflowAnalysisException {
        CallList merge = CallList.merge(start, result);
        result.copyFrom(merge);
    }

    @Override
    public void copy(CallList source, CallList dest) {
        dest.copyFrom(source);
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, CallList fact) throws DataflowAnalysisException {
        Call call = this.callMap.get(handle);
        if (call != null) {
            fact.add(call);
        }
    }

    @Override
    public boolean isFactValid(CallList fact) {
        return fact.isValid();
    }
}

