/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.jsr305.SourceSinkInfo;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import javax.annotation.meta.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FlowValue {
    TOP(0),
    ALWAYS(1),
    NEVER(4),
    UNKNOWN(7);

    private final int bits;
    private static final FlowValue[][] mergeMatrix;

    private FlowValue(int bits) {
        this.bits = bits;
    }

    public boolean isYes() {
        return (this.bits & 1) != 0;
    }

    public boolean isUncertain() {
        return (this.bits & 2) != 0;
    }

    public boolean isNo() {
        return (this.bits & 4) != 0;
    }

    public static final FlowValue meet(FlowValue a, FlowValue b) {
        int bIndex;
        int aIndex = a.ordinal();
        if (aIndex < (bIndex = b.ordinal())) {
            int tmp = aIndex;
            aIndex = bIndex;
            bIndex = tmp;
        }
        return mergeMatrix[aIndex][bIndex];
    }

    public static boolean valuesConflict(FlowValue forward, FlowValue backward) {
        if (forward == TOP || backward == TOP) {
            return false;
        }
        return forward == ALWAYS && backward == NEVER || forward == NEVER && backward == ALWAYS;
    }

    public static FlowValue flowValueFromWhen(When when) {
        switch (when) {
            case ALWAYS: {
                return ALWAYS;
            }
            case MAYBE: {
                return UNKNOWN;
            }
            case NEVER: {
                return NEVER;
            }
            case UNKNOWN: {
                return UNKNOWN;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean backwardsValueConflictsWithSource(FlowValue backwardsFlowValue, SourceSinkInfo source, TypeQualifierValue typeQualifierValue) {
        When sourceWhen = source.getWhen();
        if (typeQualifierValue.isStrictQualifier()) {
            return backwardsFlowValue == ALWAYS && sourceWhen != When.ALWAYS || backwardsFlowValue == NEVER && sourceWhen != When.NEVER;
        }
        return backwardsFlowValue == ALWAYS && (sourceWhen == When.NEVER || sourceWhen == When.MAYBE) || backwardsFlowValue == NEVER && (sourceWhen == When.ALWAYS || sourceWhen == When.MAYBE);
    }

    static {
        mergeMatrix = new FlowValue[][]{{TOP}, {ALWAYS, ALWAYS}, {NEVER, UNKNOWN, NEVER}, {UNKNOWN, UNKNOWN, UNKNOWN, UNKNOWN}};
    }

    private static interface Bits {
        public static final int YES = 1;
        public static final int UNCERTAIN = 2;
        public static final int NO = 4;
    }
}

