/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe2;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CompactLocationNumbering;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.ForwardDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe2.Condition;
import edu.umd.cs.findbugs.ba.npe2.Decision;
import edu.umd.cs.findbugs.ba.npe2.DefinitelyNullSet;
import edu.umd.cs.findbugs.ba.npe2.IfNullCondition;
import edu.umd.cs.findbugs.ba.npe2.NullnessValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitelyNullSetAnalysis
extends ForwardDataflowAnalysis<DefinitelyNullSet> {
    private ValueNumberDataflow vnaDataflow;
    private Map<BasicBlock, Condition> conditionMap;
    private static final BitSet IFNULL_OPCODE_SET = new BitSet();
    private static final BitSet IFACMP_OPCODE_SET = new BitSet();
    private static final BitSet REFCMP_OPCODE_SET = new BitSet();

    public DefinitelyNullSetAnalysis(DepthFirstSearch dfs, ValueNumberDataflow vnaDataflow, CompactLocationNumbering compactLocationNumbering) {
        super(dfs);
        this.vnaDataflow = vnaDataflow;
        this.conditionMap = new HashMap<BasicBlock, Condition>();
    }

    @Override
    public boolean isFactValid(DefinitelyNullSet fact) {
        return fact.isValid();
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, DefinitelyNullSet fact) throws DataflowAnalysisException {
        Condition condition;
        Location location = new Location(handle, basicBlock);
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(location);
        if (!vnaFrame.isValid()) {
            fact.setTop();
            return;
        }
        short opcode = handle.getInstruction().getOpcode();
        if (opcode == 1) {
            this.setTOS(vnaFrame, location, fact, NullnessValue.definitelyNullValue());
        } else if (opcode == 18 || opcode == 187) {
            this.setTOS(vnaFrame, location, fact, NullnessValue.definitelyNotNullValue());
        }
        if (handle == basicBlock.getLastInstruction() && REFCMP_OPCODE_SET.get(opcode) && (condition = this.getCondition(basicBlock)) != null) {
            condition.refresh((ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location), fact);
        }
    }

    private Condition getCondition(BasicBlock basicBlock) throws DataflowAnalysisException {
        Condition condition = this.conditionMap.get(basicBlock);
        if (condition == null) {
            Location location = new Location(basicBlock.getLastInstruction(), basicBlock);
            short opcode = basicBlock.getLastInstruction().getInstruction().getOpcode();
            if (!IFNULL_OPCODE_SET.get(opcode)) {
                if (IFACMP_OPCODE_SET.get(opcode)) {
                    return null;
                }
                return null;
            }
            condition = new IfNullCondition(location);
            this.conditionMap.put(basicBlock, condition);
        }
        return condition;
    }

    @Override
    public void edgeTransfer(Edge edge, DefinitelyNullSet fact) throws DataflowAnalysisException {
        if (!fact.isValid()) {
            return;
        }
        if (((BasicBlock)edge.getSource()).isEmpty()) {
            return;
        }
        Condition condition = this.getCondition((BasicBlock)edge.getSource());
        if (condition == null) {
            return;
        }
        Decision decision = condition.getDecision(edge);
        if (!decision.isFeasible()) {
            fact.setTop();
            return;
        }
        this.changeNullnessOfValue(condition.getValueNumber(), condition.getLocation(), fact, decision.getNullnessValue());
    }

    private void setTOS(ValueNumberFrame vnaFrame, Location location, DefinitelyNullSet fact, NullnessValue nullnessValue) throws DataflowAnalysisException {
        ValueNumber valueNumber = (ValueNumber)vnaFrame.getTopValue();
        this.changeNullnessOfValue(valueNumber, location, fact, nullnessValue);
    }

    private void changeNullnessOfValue(ValueNumber valueNumber, Location location, DefinitelyNullSet fact, NullnessValue nullnessValue) throws DataflowAnalysisException {
        fact.setNullnessValue(valueNumber, nullnessValue);
        if (fact.getNulllessValue(valueNumber) != nullnessValue) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void copy(DefinitelyNullSet source, DefinitelyNullSet dest) {
        dest.makeSameAs(source);
    }

    @Override
    public DefinitelyNullSet createFact() {
        return new DefinitelyNullSet(((ValueNumberAnalysis)this.vnaDataflow.getAnalysis()).getNumValuesAllocated());
    }

    @Override
    public void initEntryFact(DefinitelyNullSet result) throws DataflowAnalysisException {
        result.clear();
    }

    @Override
    public void makeFactTop(DefinitelyNullSet fact) {
        fact.setTop();
    }

    @Override
    public boolean isTop(DefinitelyNullSet fact) {
        return fact.isTop();
    }

    @Override
    public void meetInto(DefinitelyNullSet fact, Edge edge, DefinitelyNullSet result) throws DataflowAnalysisException {
        result.mergeWith(fact);
    }

    @Override
    public boolean same(DefinitelyNullSet fact1, DefinitelyNullSet fact2) {
        return fact1.equals(fact2);
    }

    static {
        IFNULL_OPCODE_SET.set(198);
        IFNULL_OPCODE_SET.set(199);
        IFACMP_OPCODE_SET.set(165);
        IFACMP_OPCODE_SET.set(166);
        REFCMP_OPCODE_SET.or(IFNULL_OPCODE_SET);
        REFCMP_OPCODE_SET.or(IFACMP_OPCODE_SET);
    }
}

