/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.obl;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.obl.ObligationFactory;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseAction;
import edu.umd.cs.findbugs.ba.obl.ObligationPolicyDatabaseEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.generic.ReferenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObligationPolicyDatabase {
    public static final boolean DEBUG = SystemProperties.getBoolean("oa.debug.db");
    private ObligationFactory factory = new ObligationFactory();
    private LinkedList<ObligationPolicyDatabaseEntry> entryList = new LinkedList();
    private boolean strictChecking;

    public ObligationFactory getFactory() {
        return this.factory;
    }

    public void addEntry(ObligationPolicyDatabaseEntry entry) {
        this.entryList.add(entry);
    }

    public void setStrictChecking(boolean strictChecking) {
        this.strictChecking = strictChecking;
    }

    public boolean isStrictChecking() {
        return this.strictChecking;
    }

    public void getActions(ReferenceType receiverType, String methodName, String signature, boolean isStatic, Collection<ObligationPolicyDatabaseAction> actionList) {
        if (DEBUG) {
            System.out.println("Lookup for " + receiverType + "," + methodName + "," + signature + "," + isStatic + ": ");
        }
        for (ObligationPolicyDatabaseEntry entry : this.entryList) {
            if (DEBUG) {
                System.out.print("  Entry " + entry + "...");
            }
            boolean matched = entry.getActions(receiverType, methodName, signature, isStatic, actionList);
            if (!DEBUG) continue;
            System.out.println(matched ? " ==> MATCH" : " ==> no match");
        }
        if (DEBUG) {
            System.out.println("  ** Resulting action list: " + actionList);
        }
    }

    public List<ObligationPolicyDatabaseEntry> getEntries() {
        return Collections.unmodifiableList(this.entryList);
    }
}

