/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBaseEntry;
import edu.umd.cs.findbugs.classfile.impl.ZipFileCodeBase;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;

public class ZipFileCodeBaseEntry
extends AbstractScannableCodeBaseEntry {
    private final ZipFileCodeBase codeBase;
    private final ZipEntry zipEntry;

    public ZipFileCodeBaseEntry(ZipFileCodeBase codeBase, ZipEntry zipEntry) {
        this.codeBase = codeBase;
        this.zipEntry = zipEntry;
    }

    public int getNumBytes() {
        return (int)this.zipEntry.getSize();
    }

    public InputStream openResource() throws IOException {
        return this.codeBase.zipFile.getInputStream(this.zipEntry);
    }

    public AbstractScannableCodeBase getCodeBase() {
        return this.codeBase;
    }

    public String getRealResourceName() {
        return this.zipEntry.getName();
    }

    public ClassDescriptor getClassDescriptor() {
        return DescriptorFactory.createClassDescriptorFromResourceName(this.getResourceName());
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ZipFileCodeBaseEntry other = (ZipFileCodeBaseEntry)obj;
        return this.codeBase.equals(other.codeBase) && this.zipEntry.equals(other.zipEntry);
    }

    public int hashCode() {
        return 7919 * this.codeBase.hashCode() + this.zipEntry.hashCode();
    }

    public String toString() {
        return this.getCodeBase() + ":" + this.getResourceName();
    }
}

