/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantValue;

public class HugeSharedStringConstants
extends BytecodeScanningDetector {
    private static final int SIZE_OF_HUGE_CONSTANT = 500;
    HashMap<String, SortedSet<String>> map = new HashMap();
    HashMap<String, XField> definition = new HashMap();
    HashMap<String, Integer> stringSize = new HashMap();
    BugReporter bugReporter;

    String getStringKey(String s) {
        return s.length() + ":" + s.hashCode();
    }

    public HugeSharedStringConstants(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(ConstantString s) {
        String value = s.getBytes(this.getConstantPool());
        if (value.length() < 500) {
            return;
        }
        String key = this.getStringKey(value);
        SortedSet<String> set = this.map.get(key);
        if (set == null) {
            set = new TreeSet<String>();
            this.map.put(key, set);
        }
        set.add(this.getDottedClassName());
    }

    public void visit(ConstantValue s) {
        if (!this.visitingField()) {
            return;
        }
        int i = s.getConstantValueIndex();
        Constant c = this.getConstantPool().getConstant(i);
        if (c instanceof ConstantString) {
            String value = ((ConstantString)c).getBytes(this.getConstantPool());
            if (value.length() < 500) {
                return;
            }
            String key = this.getStringKey(value);
            this.definition.put(key, XFactory.createXField(this));
            this.stringSize.put(key, value.length());
        }
    }

    public void report() {
        for (Map.Entry<String, SortedSet<String>> e : this.map.entrySet()) {
            Integer length;
            int overhead;
            XField field;
            Set occursIn = e.getValue();
            if (occursIn.size() == 1 || (field = this.definition.get(e.getKey())) == null || (overhead = (length = this.stringSize.get(e.getKey())) * (occursIn.size() - 1)) < 1500) continue;
            String className = field.getClassName();
            BugInstance bug = new BugInstance(this, "HSC_HUGE_SHARED_STRING_CONSTANT", overhead > 10000 ? 1 : (overhead > 4000 ? 2 : 3)).addClass(className).addField(field).addInt(length).addInt(occursIn.size()).describe("INT_OCCURRENCES");
            for (String c : occursIn) {
                if (c.equals(className)) continue;
                bug.addClass(c);
            }
            this.bugReporter.reportBug(bug);
        }
    }
}

