/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.RelationalOp;
import edu.umd.cs.findbugs.filter.VersionMatcher;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class FirstVersionMatcher
extends VersionMatcher
implements Matcher {
    public FirstVersionMatcher(String versionAsString, String relOpAsString) {
        this(Long.parseLong(versionAsString), RelationalOp.byName(relOpAsString));
    }

    public FirstVersionMatcher(String versionAsString, RelationalOp relOp) {
        this(Long.parseLong(versionAsString), relOp);
    }

    public FirstVersionMatcher(long version, RelationalOp relOp) {
        super(version, relOp);
    }

    public String toString() {
        return "FirstVersion(version" + this.relOp + this.version + ")";
    }

    public boolean match(BugInstance bugInstance) {
        return this.relOp.check(bugInstance.getFirstVersion(), this.version);
    }

    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("value", Long.toString(this.version)).addAttribute("relOp", this.relOp.getName());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("FirstVersion", attributes);
    }
}

