/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.db.DBCloud;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class ViewFilter {
    final MainFrame mf;
    RankFilter rank = RankFilter.ALL;
    CloudFilter eval = CloudFilter.ALL;
    OverallClassificationFilter classificationFilter = OverallClassificationFilter.ALL;
    FirstSeenFilter firstSeen = FirstSeenFilter.ALL;
    String[] classSearchStrings;
    static final Pattern legalClassSearchString = Pattern.compile("[\\p{javaLowerCase}\\p{javaUpperCase}0-9.$/_]*");

    public ViewFilter(MainFrame mf) {
        this.mf = mf;
    }

    void setPackagesToDisplay(String value) {
        if ((value = value.replace('/', '.').trim()).length() == 0) {
            this.classSearchStrings = new String[0];
        } else {
            String[] parts;
            for (String p : parts = value.split("[ ,:]+")) {
                if (legalClassSearchString.matcher(p).matches()) continue;
                throw new IllegalArgumentException("Class search string isn't a legal classname substring: " + p);
            }
            this.classSearchStrings = parts;
        }
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public RankFilter getRank() {
        return this.rank;
    }

    public void setRank(RankFilter rank) {
        this.rank = rank;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public CloudFilter getEvaluation() {
        return this.eval;
    }

    public void setEvaluation(CloudFilter eval) {
        if (this.eval == eval) {
            return;
        }
        this.eval = eval;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public void setClassification(OverallClassificationFilter classificationFilter) {
        if (this.classificationFilter == classificationFilter) {
            return;
        }
        this.classificationFilter = classificationFilter;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public FirstSeenFilter getFirstSeen() {
        return this.firstSeen;
    }

    public void setFirstSeen(FirstSeenFilter firstSeen) {
        this.firstSeen = firstSeen;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public String[] getPackagePrefixes() {
        return this.classSearchStrings;
    }

    public boolean showIgnoringPackagePrefixes(BugInstance b) {
        if (!this.firstSeen.show(this.mf, b)) {
            return false;
        }
        if (!this.rank.show(this.mf, b)) {
            return false;
        }
        if (!this.eval.show(this.mf, b)) {
            return false;
        }
        return this.classificationFilter.show(this.mf, b);
    }

    public static boolean matchedPrefixes(String[] classSearchStrings, @DottedClassName String className) {
        return ClassName.matchedPrefixes(classSearchStrings, className);
    }

    public boolean show(BugInstance b) {
        String className = b.getPrimaryClass().getClassName();
        return ClassName.matchedPrefixes(this.classSearchStrings, className) && this.showIgnoringPackagePrefixes(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FirstSeenFilter implements ViewFilterEnum
    {
        LAST_DAY(1, "Last day"),
        LAST_3_DAYS(3, "Last 3 days"),
        LAST_WEEK(7, "Last week"),
        LAST_MONTH(30, "Last month"),
        LAST_THREE_MONTHS(91, "Last 90 days"),
        ALL(400000, "No matter when first seen");

        final int maxDays;
        final String displayName;

        private FirstSeenFilter(int days, String displayName) {
            this.maxDays = days;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            long firstSeen = mf.bugCollection.getCloud().getFirstSeen(b);
            long time = System.currentTimeMillis() - firstSeen;
            long days = TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS) / 3600L / 24L;
            return days < (long)this.maxDays;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CloudFilter implements ViewFilterEnum
    {
        MY_REVIEWS("Classified by me"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getReviewers(b).contains(cloud.getUser());
            }
        }
        ,
        NOT_REVIEWED_BY_ME("Not classified by me"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.getReviewers(b).contains(cloud.getUser());
            }
        }
        ,
        NO_REVIEWS("No one has classified"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getReviewers(b).isEmpty();
            }

            public boolean supported(Cloud cloud) {
                return cloud instanceof DBCloud && cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        HAS_REVIEWS("Someone has classified"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.getReviewers(b).isEmpty();
            }

            public boolean supported(Cloud cloud) {
                return cloud instanceof DBCloud && cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        NO_ONE_COMMITTED_TO_FIXING("Has no fixers"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.isClaimed(b);
            }

            public boolean supported(Cloud cloud) {
                return cloud instanceof DBCloud && cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        I_WILL_FIX("I will fix"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getIWillFix(b);
            }
        }
        ,
        HAS_FILED_BUGS("Has entry in bug database"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getBugLinkStatus(b).bugIsFiled();
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        NO_FILED_BUGS("Don't have entry in bug database"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.getBugLinkStatus(b).bugIsFiled();
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        WILL_NOT_FIX("bug database entry marked Will Not Fix"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getWillNotBeFixed(b);
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        BUG_STATUS_IS_UNASSIGNED("bug database entry is unassigned"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getBugIsUnassigned(b);
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        ALL("All issues"){

            boolean show(DBCloud cloud, BugInstance b) {
                return true;
            }
        };

        final String displayName;

        private CloudFilter(String displayName) {
            this.displayName = displayName;
        }

        abstract boolean show(DBCloud var1, BugInstance var2);

        public boolean supported(Cloud cloud) {
            return true;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            Cloud c = mf.bugCollection.getCloud();
            if (c instanceof DBCloud) {
                return this.show((DBCloud)c, b);
            }
            return true;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OverallClassificationFilter implements ViewFilterEnum
    {
        SHOULD_FIX("Overall classification is should fix"){

            boolean show(DBCloud cloud, BugInstance b) {
                double score = cloud.getClassificationScore(b);
                return score >= (double)Cloud.UserDesignation.SHOULD_FIX.score();
            }
        }
        ,
        DONT_FIX("Overall classification is don't fix"){

            boolean show(DBCloud cloud, BugInstance b) {
                double score = cloud.getClassificationScore(b);
                return score <= (double)Cloud.UserDesignation.MOSTLY_HARMLESS.score();
            }
        }
        ,
        OBSOLETE("Overall classification is obsolete code"){

            boolean show(DBCloud cloud, BugInstance b) {
                double score = cloud.getPortionObsoleteClassifications(b);
                return score >= 0.5;
            }
        }
        ,
        UNCERTAIN("Overall classification is uncertain"){

            boolean show(DBCloud cloud, BugInstance b) {
                if (SHOULD_FIX.show(cloud, b) || DONT_FIX.show(cloud, b) || OBSOLETE.show(cloud, b)) {
                    return false;
                }
                return cloud.getNumberReviewers(b) >= 2;
            }
        }
        ,
        HIGH_VARIANCE("Controversial"){

            boolean show(DBCloud cloud, BugInstance b) {
                double variance = cloud.getClassificationDisagreement(b);
                return variance > 0.26;
            }
        }
        ,
        ALL("All issues"){

            boolean show(DBCloud cloud, BugInstance b) {
                return true;
            }
        };

        final String displayName;

        private OverallClassificationFilter(String displayName) {
            this.displayName = displayName;
        }

        abstract boolean show(DBCloud var1, BugInstance var2);

        public boolean supported(Cloud cloud) {
            return true;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            Cloud c = mf.bugCollection.getCloud();
            if (c instanceof DBCloud) {
                return this.show((DBCloud)c, b);
            }
            return true;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RankFilter implements ViewFilterEnum
    {
        SCARIEST(4, "Scariest"),
        SCARY(9, "Scary"),
        TROUBLING(14, "Troubling"),
        ALL(Integer.MAX_VALUE, "All bug ranks");

        final int maxRank;
        final String displayName;

        private RankFilter(int maxRank, String displayName) {
            this.maxRank = maxRank;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            int rank = BugRanker.findRank(b);
            return rank <= this.maxRank;
        }

        public String toString() {
            if (this.maxRank < Integer.MAX_VALUE) {
                return this.displayName + " (Ranks 1 - " + this.maxRank + ")";
            }
            return this.displayName;
        }
    }

    static interface ViewFilterEnum {
        public boolean show(MainFrame var1, BugInstance var2);
    }
}

