/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.annotation.WillNotClose;

public class IO {
    static ThreadLocal<byte[]> myByteBuf = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4096];
        }
    };
    static ThreadLocal<char[]> myCharBuf = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[4096];
        }
    };

    public static String readAll(InputStream in) throws IOException {
        return IO.readAll(new InputStreamReader(in));
    }

    public static String readAll(Reader reader) throws IOException {
        BufferedReader r = new BufferedReader(reader);
        StringWriter w = new StringWriter();
        IO.copy(r, w);
        return w.toString();
    }

    public static long copy(@WillNotClose InputStream in, @WillNotClose OutputStream out) throws IOException {
        return IO.copy(in, out, Long.MAX_VALUE);
    }

    public static long copy(Reader in, Writer out) throws IOException {
        return IO.copy(in, out, Long.MAX_VALUE);
    }

    public static long copy(@WillNotClose InputStream in, @WillNotClose OutputStream out, long maxBytes) throws IOException {
        long total = 0L;
        int sz = 0;
        byte[] buf = myByteBuf.get();
        while (maxBytes > 0L && (sz = in.read(buf, 0, (int)Math.min(maxBytes, (long)buf.length))) > 0) {
            total += (long)sz;
            maxBytes -= (long)sz;
            out.write(buf, 0, sz);
        }
        return total;
    }

    public static long copy(Reader in, Writer out, long maxChars) throws IOException {
        int sz;
        long total = 0L;
        char[] buf = myCharBuf.get();
        while (maxChars > 0L && (sz = in.read(buf, 0, (int)Math.min(maxChars, (long)buf.length))) > 0) {
            total += (long)sz;
            maxChars -= (long)sz;
            out.write(buf, 0, sz);
        }
        return total;
    }

    public static void close(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void skipFully(InputStream in, long bytes) throws IOException {
        long skipped;
        if (bytes < 0L) {
            throw new IllegalArgumentException("Can't skip " + bytes + " bytes");
        }
        for (long remaining = bytes; remaining > 0L; remaining -= skipped) {
            skipped = in.skip(remaining);
            if (skipped > 0L) continue;
            throw new EOFException("Reached EOF while trying to skip a total of " + bytes);
        }
    }
}

