/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sourceViewer;

import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.gui2.Debug;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.GUISaveState;
import edu.umd.cs.findbugs.sourceViewer.DocumentCharacterIterator;
import edu.umd.cs.findbugs.sourceViewer.HighlightInformation;
import edu.umd.cs.findbugs.sourceViewer.JavaScanner;
import edu.umd.cs.findbugs.sourceViewer.NumberedEditorKit;
import edu.umd.cs.findbugs.sourceViewer.NumberedParagraphView;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

public class JavaSourceDocument {
    static final SimpleAttributeSet commentAttributes = new SimpleAttributeSet();
    static final SimpleAttributeSet javadocAttributes = new SimpleAttributeSet();
    static final SimpleAttributeSet quotesAttributes = new SimpleAttributeSet();
    static final SimpleAttributeSet keywordsAttributes = new SimpleAttributeSet();
    static final SimpleAttributeSet whiteAttributes = new SimpleAttributeSet();
    static Font sourceFont = new Font("Monospaced", 0, (int)Driver.getFontSize());
    static final Color HIGHLIGHT_COLOR = new Color(1.0f, 1.0f, 0.3f);
    TabSet TAB_SET;
    final HighlightInformation highlights = new HighlightInformation();
    final NumberedEditorKit dek = new NumberedEditorKit(this.highlights);
    final StyleContext styleContext = new StyleContext();
    final Element root;
    final DefaultStyledDocument doc = new DefaultStyledDocument();
    final SourceFile sourceFile;
    private final String title;
    private static final long serialVersionUID = 0L;
    public static final JavaSourceDocument UNKNOWNSOURCE;

    public HighlightInformation getHighlightInformation() {
        return this.highlights;
    }

    public StyledDocument getDocument() {
        return this.doc;
    }

    public NumberedEditorKit getEditorKit() {
        return this.dek;
    }

    public String getTitle() {
        return this.title;
    }

    public SourceFile getSourceFile() {
        return this.sourceFile;
    }

    public JavaSourceDocument(String title, Reader in, SourceFile theSource) throws IOException {
        this.title = title;
        this.sourceFile = theSource;
        Debug.println("Created JavaSourceDocument for " + title);
        try {
            this.dek.read(in, (Document)this.doc, 0);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        in.close();
        this.doc.putProperty("title", title);
        this.root = this.doc.getDefaultRootElement();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        FontMetrics fontMetrics = toolkit.getFontMetrics(sourceFont);
        TabStop[] tabs = new TabStop[50];
        float width = fontMetrics.stringWidth(" ");
        int tabSize = GUISaveState.getInstance().getTabSize();
        for (int i = 0; i < tabs.length; ++i) {
            tabs[i] = new TabStop(width * (float)(tabSize + tabSize * i));
        }
        this.TAB_SET = new TabSet(tabs);
        StyleConstants.setTabSet(commentAttributes, this.TAB_SET);
        StyleConstants.setTabSet(javadocAttributes, this.TAB_SET);
        StyleConstants.setTabSet(quotesAttributes, this.TAB_SET);
        StyleConstants.setTabSet(keywordsAttributes, this.TAB_SET);
        StyleConstants.setTabSet(commentAttributes, this.TAB_SET);
        StyleConstants.setTabSet(whiteAttributes, this.TAB_SET);
        StyleConstants.setFontFamily(whiteAttributes, sourceFont.getFamily());
        StyleConstants.setFontSize(whiteAttributes, sourceFont.getSize());
        StyleConstants.setLeftIndent(whiteAttributes, NumberedParagraphView.NUMBERS_WIDTH);
        this.doc.setParagraphAttributes(0, this.doc.getLength(), whiteAttributes, true);
        JavaScanner parser = new JavaScanner(new DocumentCharacterIterator(this.doc));
        while (parser.next() != -1) {
            int kind = parser.getKind();
            switch (kind) {
                case 1: {
                    this.doc.setCharacterAttributes(parser.getStartPosition(), parser.getLength(), commentAttributes, true);
                    break;
                }
                case 3: {
                    this.doc.setCharacterAttributes(parser.getStartPosition(), parser.getLength(), keywordsAttributes, true);
                    break;
                }
                case 2: {
                    this.doc.setCharacterAttributes(parser.getStartPosition(), parser.getLength(), javadocAttributes, true);
                    break;
                }
                case 4: {
                    this.doc.setCharacterAttributes(parser.getStartPosition(), parser.getLength(), quotesAttributes, true);
                }
            }
        }
    }

    static {
        commentAttributes.addAttribute(StyleConstants.Foreground, new Color(0.0f, 0.5f, 0.0f));
        javadocAttributes.addAttribute(StyleConstants.Foreground, new Color(0.25f, 0.37f, 0.75f));
        quotesAttributes.addAttribute(StyleConstants.Foreground, new Color(0.0f, 0.0f, 1.0f));
        keywordsAttributes.addAttribute(StyleConstants.Foreground, new Color(0.5f, 0.0f, 0.5f));
        keywordsAttributes.addAttribute(StyleConstants.Bold, true);
        try {
            UNKNOWNSOURCE = new JavaSourceDocument("Unknown source", new StringReader("Unable to find source"), null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

