/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.config.CommandLine;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejarClassesForAnalysis {
    final RejarClassesForAnalysisCommandLine commandLine;
    final int argCount;
    final String[] args;
    SortedMap<String, ZipOutputStream> analysisOutputFiles = new TreeMap<String, ZipOutputStream>();
    int analysisCount = 1;
    int auxilaryCount = 1;
    Set<String> copied = new HashSet<String>();
    Set<String> excluded = new HashSet<String>();
    TreeSet<String> filesToAnalyze = new TreeSet();
    int numFilesToAnalyze = 0;
    int auxilaryClassCount = 0;
    ZipOutputStream auxilaryOut;
    final byte[] buffer = new byte[8192];

    public RejarClassesForAnalysis(RejarClassesForAnalysisCommandLine commandLine, int argCount, String[] args) {
        this.commandLine = commandLine;
        this.argCount = argCount;
        this.args = args;
    }

    public static List<String> readFromStandardInput() throws IOException {
        return RejarClassesForAnalysis.readFrom(new InputStreamReader(System.in));
    }

    @Nonnull
    public ZipOutputStream getZipOutputFile(String path) {
        ZipOutputStream result = (ZipOutputStream)this.analysisOutputFiles.get(path);
        if (result != null) {
            return result;
        }
        SortedMap<String, ZipOutputStream> head = this.analysisOutputFiles.headMap(path);
        String matchingPath = head.lastKey();
        result = (ZipOutputStream)this.analysisOutputFiles.get(matchingPath);
        if (result == null) {
            throw new IllegalArgumentException("No zip output file for " + path);
        }
        return result;
    }

    public static List<String> readFrom(@WillClose Reader r) throws IOException {
        BufferedReader in = new BufferedReader(r);
        LinkedList<String> lst = new LinkedList<String>();
        while (true) {
            String s;
            if ((s = in.readLine()) == null) {
                in.close();
                return lst;
            }
            lst.add(s);
        }
    }

    String getNextAuxilaryFileOutput() {
        String result = this.auxilaryCount == 1 ? "auxilary.jar" : "auxilary" + this.auxilaryCount + ".jar";
        ++this.auxilaryCount;
        System.out.println("Starting " + result);
        return result;
    }

    String getNextAnalyzeFileOutput() {
        String result = this.analysisCount == 1 ? "analyze.jar" : "analyze" + this.analysisCount + ".jar";
        ++this.analysisCount;
        System.out.println("Starting " + result);
        return result;
    }

    public static void main(String[] args) throws Exception {
        RejarClassesForAnalysisCommandLine commandLine = new RejarClassesForAnalysisCommandLine();
        int argCount = commandLine.parse(args, 0, Integer.MAX_VALUE, "Usage: " + RejarClassesForAnalysis.class.getName() + " [options] [<jarFile>+] ");
        RejarClassesForAnalysis doit = new RejarClassesForAnalysis(commandLine, argCount, args);
        doit.execute();
    }

    private boolean exclude(String dottedName) {
        if (this.commandLine.excludePatterns != null && this.commandLine.excludePatterns.matches(dottedName) || this.commandLine.exclude.matches(dottedName)) {
            this.excluded.add(dottedName);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws IOException {
        int oldSize;
        File f;
        List<String> fileList = this.commandLine.inputFileList != null ? RejarClassesForAnalysis.readFrom(new FileReader(this.commandLine.inputFileList)) : (this.argCount == this.args.length ? RejarClassesForAnalysis.readFromStandardInput() : Arrays.asList(this.args).subList(this.argCount, this.args.length));
        List<Object> auxFileList = Collections.emptyList();
        if (this.commandLine.auxFileList != null) {
            auxFileList = RejarClassesForAnalysis.readFrom(new FileReader(this.commandLine.auxFileList));
        }
        ArrayList<File> inputZipFiles = new ArrayList<File>(fileList.size());
        ArrayList<File> auxZipFiles = new ArrayList<File>(auxFileList.size());
        for (String string : fileList) {
            f = new File(string);
            if (f.lastModified() < this.commandLine.maxAge) {
                System.err.println("Skipping " + string + ", too old (" + new Date(f.lastModified()) + ")");
                continue;
            }
            oldSize = this.copied.size();
            if (!this.processZipEntries(f, new ZipElementHandler(){

                public void handle(ZipFile file, ZipEntry ze) {
                    String name = ze.getName();
                    String dottedName = name.replace('/', '.');
                    if (RejarClassesForAnalysis.this.exclude(dottedName)) {
                        return;
                    }
                    if (RejarClassesForAnalysis.this.copied.add(name) && RejarClassesForAnalysis.this.commandLine.prefix.matches(dottedName)) {
                        RejarClassesForAnalysis.this.filesToAnalyze.add(name);
                        ++RejarClassesForAnalysis.this.numFilesToAnalyze;
                    }
                }
            }) || oldSize >= this.copied.size()) continue;
            inputZipFiles.add(f);
        }
        for (String string : auxFileList) {
            f = new File(string);
            if (f.lastModified() < this.commandLine.maxAge) {
                System.err.println("Skipping " + string + ", too old (" + new Date(f.lastModified()) + ")");
                continue;
            }
            oldSize = this.copied.size();
            if (!this.processZipEntries(f, new ZipElementHandler(){

                public void handle(ZipFile file, ZipEntry ze) {
                    String name = ze.getName();
                    String dottedName = name.replace('/', '.');
                    if (!RejarClassesForAnalysis.this.exclude(dottedName)) {
                        RejarClassesForAnalysis.this.copied.add(ze.getName());
                    }
                }
            }) || oldSize >= this.copied.size()) continue;
            auxZipFiles.add(f);
        }
        System.out.printf("    # Zip/jar files: %2d\n", inputZipFiles.size());
        System.out.printf("# aux Zip/jar files: %2d\n", auxZipFiles.size());
        System.out.printf("Unique class files: %6d\n", this.copied.size());
        if (this.numFilesToAnalyze != this.copied.size()) {
            System.out.printf("  files to analyze: %6d\n", this.numFilesToAnalyze);
        }
        if (!this.excluded.isEmpty()) {
            System.out.printf("   excluded  files: %6d\n", this.excluded.size());
        }
        if (this.numFilesToAnalyze < this.copied.size() || this.numFilesToAnalyze > this.commandLine.maxClasses) {
            this.auxilaryOut = this.createZipFile(this.getNextAuxilaryFileOutput());
        }
        this.copied.clear();
        int count = Integer.MAX_VALUE;
        String string = "xx";
        String oldPackage = "xx";
        for (String path : this.filesToAnalyze) {
            void var6_11;
            String baseClass;
            int lastSlash = path.lastIndexOf(47);
            String packageName = lastSlash <= 0 ? "" : path.substring(0, lastSlash - 1);
            int firstDollar = path.indexOf(36, lastSlash);
            String string2 = baseClass = firstDollar < 0 ? path : path.substring(0, firstDollar - 1);
            boolean switchOutput = count > this.commandLine.maxClasses ? true : (count + 50 > this.commandLine.maxClasses && !baseClass.equals(var6_11) ? true : count + 250 > this.commandLine.maxClasses && !packageName.equals(oldPackage));
            if (switchOutput) {
                String zipFileName = this.getNextAnalyzeFileOutput();
                this.analysisOutputFiles.put(path, this.createZipFile(zipFileName));
                System.out.printf("%s\n -> %s\n", path, zipFileName);
                count = 0;
            }
            ++count;
            oldPackage = packageName;
            String string3 = baseClass;
        }
        for (File f2 : inputZipFiles) {
            System.err.println("Reading " + f2);
            this.processZipEntries(f2, new ZipElementHandler(){

                public void handle(ZipFile zipInputFile, ZipEntry ze) throws IOException {
                    String name = ze.getName();
                    String dottedName = name.replace('/', '.');
                    if (RejarClassesForAnalysis.this.exclude(dottedName)) {
                        return;
                    }
                    if (!RejarClassesForAnalysis.this.copied.add(name)) {
                        return;
                    }
                    boolean writeToAnalyzeOut = false;
                    boolean writeToAuxilaryOut = false;
                    if (RejarClassesForAnalysis.this.commandLine.prefix.matches(dottedName)) {
                        writeToAnalyzeOut = true;
                        if (RejarClassesForAnalysis.this.numFilesToAnalyze > RejarClassesForAnalysis.this.commandLine.maxClasses) {
                            writeToAuxilaryOut = true;
                        }
                    } else {
                        writeToAuxilaryOut = RejarClassesForAnalysis.this.auxilaryOut != null;
                    }
                    ZipOutputStream out = null;
                    if (writeToAnalyzeOut) {
                        out = RejarClassesForAnalysis.this.getZipOutputFile(name);
                        out.putNextEntry(new ZipEntry(name));
                    }
                    if (writeToAuxilaryOut) {
                        ++RejarClassesForAnalysis.this.auxilaryClassCount;
                        if (RejarClassesForAnalysis.this.auxilaryClassCount > 29999) {
                            RejarClassesForAnalysis.this.auxilaryClassCount = 0;
                            RejarClassesForAnalysis.this.advanceAuxilaryOut();
                        }
                        RejarClassesForAnalysis.this.auxilaryOut.putNextEntry(new ZipEntry(name));
                    }
                    RejarClassesForAnalysis.this.copyEntry(zipInputFile, ze, writeToAnalyzeOut, out, writeToAuxilaryOut, RejarClassesForAnalysis.this.auxilaryOut);
                }
            });
        }
        for (File f2 : auxZipFiles) {
            System.err.println("Opening aux file " + f2);
            this.processZipEntries(f2, new ZipElementHandler(){

                public void handle(ZipFile zipInputFile, ZipEntry ze) throws IOException {
                    String name = ze.getName();
                    String dottedName = name.replace('/', '.');
                    if (RejarClassesForAnalysis.this.exclude(dottedName)) {
                        return;
                    }
                    if (!RejarClassesForAnalysis.this.copied.add(name)) {
                        return;
                    }
                    ++RejarClassesForAnalysis.this.auxilaryClassCount;
                    if (RejarClassesForAnalysis.this.auxilaryClassCount > 29999) {
                        RejarClassesForAnalysis.this.auxilaryClassCount = 0;
                        RejarClassesForAnalysis.this.advanceAuxilaryOut();
                    }
                    RejarClassesForAnalysis.this.auxilaryOut.putNextEntry(new ZipEntry(name));
                    RejarClassesForAnalysis.this.copyEntry(zipInputFile, ze, false, null, true, RejarClassesForAnalysis.this.auxilaryOut);
                }
            });
        }
        if (this.auxilaryOut != null) {
            this.auxilaryOut.close();
        }
        for (ZipOutputStream out : this.analysisOutputFiles.values()) {
            out.close();
        }
        System.out.println("All done");
    }

    private ZipOutputStream createZipFile(String fileName) throws FileNotFoundException {
        File newFile = new File(this.commandLine.outputDir, fileName);
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
    }

    private void copyEntry(ZipFile zipInputFile, ZipEntry ze, boolean writeToAnalyzeOut, ZipOutputStream analyzeOut1, boolean writeToAuxilaryOut, ZipOutputStream auxilaryOut1) throws IOException {
        int bytesRead;
        InputStream zipIn = zipInputFile.getInputStream(ze);
        while ((bytesRead = zipIn.read(this.buffer)) >= 0) {
            if (writeToAnalyzeOut) {
                analyzeOut1.write(this.buffer, 0, bytesRead);
            }
            if (!writeToAuxilaryOut) continue;
            auxilaryOut1.write(this.buffer, 0, bytesRead);
        }
        if (writeToAnalyzeOut) {
            analyzeOut1.closeEntry();
        }
        if (writeToAuxilaryOut) {
            auxilaryOut1.closeEntry();
        }
        zipIn.close();
    }

    private void advanceAuxilaryOut() throws IOException, FileNotFoundException {
        this.auxilaryOut.close();
        this.auxilaryOut = this.createZipFile(this.getNextAuxilaryFileOutput());
    }

    boolean processZipEntries(File f, ZipElementHandler handler) {
        if (!f.exists()) {
            System.out.println("file not found: '" + f + "'");
            return false;
        }
        if (!f.canRead() || f.isDirectory()) {
            System.out.println("not readable: '" + f + "'");
            return false;
        }
        try {
            ZipFile zipInputFile = new ZipFile(f);
            Enumeration<? extends ZipEntry> e = zipInputFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory() || !ze.getName().endsWith(".class") || ze.getSize() == 0L) continue;
                handler.handle(zipInputFile, ze);
            }
            zipInputFile.close();
        }
        catch (IOException e) {
            System.out.println("Error processing '" + f + "'");
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    static interface ZipElementHandler {
        public void handle(ZipFile var1, ZipEntry var2) throws IOException;
    }

    static class RejarClassesForAnalysisCommandLine
    extends CommandLine {
        PrefixMatcher prefix = new PrefixMatcher("");
        PrefixMatcher exclude = new PrefixMatcher();
        PatternMatcher excludePatterns = null;
        int maxClasses = 29999;
        long maxAge = Long.MIN_VALUE;
        public String inputFileList;
        public String auxFileList;
        File outputDir = new File(".");

        RejarClassesForAnalysisCommandLine() {
            this.addOption("-maxAge", "days", "maximum age in days (ignore jar files older than this)");
            this.addOption("-inputFileList", "filename", "text file containing names of jar files");
            this.addOption("-auxFileList", "filename", "text file containing names of jar files for aux class path");
            this.addOption("-maxClasses", "num", "maximum number of classes per analysis*.jar file");
            this.addOption("-outputDir", "dir", "directory for the generated jar files");
            this.addOption("-prefix", "class name prefix", "comma separated list of class name prefixes that should be analyzed (e.g., edu.umd.cs.)");
            this.addOption("-exclude", "class name prefix", "comma separated list of class name prefixes that should be  excluded from both analyze and auxilary jar files (e.g., java.)");
            this.addOption("-excludePattern", "class name pattern(s)", "comma separated list of regular expressions; all classes matching them are excluded");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            throw new IllegalArgumentException("Unknown option : " + option);
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-prefix")) {
                this.prefix = new PrefixMatcher(argument);
            } else if (option.equals("-exclude")) {
                this.exclude = new PrefixMatcher(argument);
            } else if (option.equals("-inputFileList")) {
                this.inputFileList = argument;
            } else if (option.equals("-auxFileList")) {
                this.auxFileList = argument;
            } else if (option.equals("-maxClasses")) {
                this.maxClasses = Integer.parseInt(argument);
            } else if (option.equals("-maxAge")) {
                this.maxAge = System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(argument);
            } else if (option.equals("-outputDir")) {
                this.outputDir = new File(argument);
            } else if (option.equals("-excludePattern")) {
                this.excludePatterns = new PatternMatcher(argument);
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }

        static class PrefixMatcher {
            final String[] prefixes;

            PrefixMatcher(String arg) {
                this.prefixes = arg.split(",");
            }

            PrefixMatcher() {
                this.prefixes = new String[0];
            }

            public boolean matches(String arg) {
                for (String p : this.prefixes) {
                    if (!arg.startsWith(p)) continue;
                    return true;
                }
                return false;
            }

            public boolean matchesEverything() {
                for (String p : this.prefixes) {
                    if (p.length() != 0) continue;
                    return true;
                }
                return false;
            }
        }

        static class PatternMatcher {
            final Pattern[] pattern;

            PatternMatcher(String arg) {
                String[] p = arg.split(",");
                this.pattern = new Pattern[p.length];
                for (int i = 0; i < p.length; ++i) {
                    this.pattern[i] = Pattern.compile(p[i]);
                }
            }

            public boolean matches(String arg) {
                for (Pattern p : this.pattern) {
                    if (!p.matcher(arg).find()) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

