/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.AllocationInstrumenter;
import java.util.LinkedList;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.LocalVariablesSorter;

class AllocationMethodAdapter
extends MethodAdapter {
    public static final String RECORDER_SIGNATURE = "(ILjava/lang/String;Ljava/lang/Object;)V";
    public static final String CLASS_RECORDER_SIG = "(Ljava/lang/Class;Ljava/lang/Object;)V";
    private static final String[] primitiveTypeNames = new String[]{"INVALID0", "INVALID1", "INVALID2", "INVALID3", "boolean", "char", "float", "double", "byte", "short", "int", "long"};
    private int outstandingAllocs = 0;
    private List<VariableScope> localScopes = null;
    private final String recorderClass;
    private final String recorderMethod;
    public LocalVariablesSorter lvs = null;

    private List<VariableScope> getLocalScopes() {
        if (this.localScopes == null) {
            this.localScopes = new LinkedList<VariableScope>();
        }
        return this.localScopes;
    }

    public AllocationMethodAdapter(MethodVisitor mv, String recorderClass, String recorderMethod) {
        super(mv);
        this.recorderClass = recorderClass;
        this.recorderMethod = recorderMethod;
    }

    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188) {
            if (operand >= 4 && operand <= 11) {
                super.visitInsn(89);
                super.visitIntInsn(opcode, operand);
                this.invokeRecordAllocation(primitiveTypeNames[operand]);
            } else {
                AllocationInstrumenter.logger.severe("NEWARRAY called with an invalid operand " + operand + ".  Not instrumenting this allocation!");
                super.visitIntInsn(opcode, operand);
            }
        } else {
            super.visitIntInsn(opcode, operand);
        }
    }

    private void pushClassNameOnStack() {
        super.visitInsn(89);
        super.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;");
        super.visitLdcInsn((Object)Character.valueOf('.'));
        super.visitLdcInsn((Object)Character.valueOf('/'));
        super.visitMethodInsn(182, "java/lang/String", "replace", "(CC)Ljava/lang/String;");
    }

    private void pushProductOfIntArrayOnStack() {
        Label beginScopeLabel = new Label();
        Label endScopeLabel = new Label();
        int dimsArrayIndex = this.newLocal("[I", beginScopeLabel, endScopeLabel);
        int counterIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
        int productIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
        Label loopLabel = new Label();
        Label endLabel = new Label();
        super.visitLabel(beginScopeLabel);
        super.visitVarInsn(58, dimsArrayIndex);
        super.visitInsn(3);
        super.visitVarInsn(54, counterIndex);
        super.visitInsn(4);
        super.visitVarInsn(54, productIndex);
        super.visitLabel(loopLabel);
        super.visitVarInsn(21, counterIndex);
        super.visitVarInsn(25, dimsArrayIndex);
        super.visitInsn(190);
        super.visitJumpInsn(162, endLabel);
        super.visitVarInsn(25, dimsArrayIndex);
        super.visitVarInsn(21, counterIndex);
        super.visitInsn(46);
        super.visitInsn(89);
        Label nonZeroDimension = new Label();
        super.visitJumpInsn(154, nonZeroDimension);
        super.visitInsn(87);
        super.visitInsn(4);
        super.visitLabel(nonZeroDimension);
        super.visitVarInsn(21, productIndex);
        super.visitInsn(104);
        super.visitVarInsn(54, productIndex);
        super.visitIincInsn(counterIndex, 1);
        super.visitJumpInsn(167, loopLabel);
        super.visitLabel(endLabel);
        super.visitVarInsn(25, dimsArrayIndex);
        super.visitVarInsn(21, productIndex);
        super.visitLabel(endScopeLabel);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String signature) {
        if (opcode == 184 && owner.equals("java/lang/reflect/Array") && name.equals("newInstance")) {
            if (signature.equals("(Ljava/lang/Class;I)Ljava/lang/Object;")) {
                Label beginScopeLabel = new Label();
                Label endScopeLabel = new Label();
                super.visitLabel(beginScopeLabel);
                int countIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(54, countIndex);
                this.pushClassNameOnStack();
                int typeNameIndex = this.newLocal("Ljava/lang/String;", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(58, typeNameIndex);
                super.visitVarInsn(21, countIndex);
                super.visitMethodInsn(opcode, owner, name, signature);
                super.visitInsn(89);
                super.visitVarInsn(21, countIndex);
                super.visitInsn(95);
                super.visitVarInsn(25, typeNameIndex);
                super.visitLabel(endScopeLabel);
                super.visitInsn(95);
                super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, RECORDER_SIGNATURE);
                return;
            }
            if (signature.equals("(Ljava/lang/Class;[I)Ljava/lang/Object;")) {
                Label beginScopeLabel = new Label();
                Label endScopeLabel = new Label();
                super.visitLabel(beginScopeLabel);
                int dimsArrayIndex = this.newLocal("[I", beginScopeLabel, endScopeLabel);
                this.pushProductOfIntArrayOnStack();
                int productIndex = this.newLocal("I", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(54, productIndex);
                super.visitVarInsn(58, dimsArrayIndex);
                this.pushClassNameOnStack();
                int typeNameIndex = this.newLocal("Ljava/lang/String;", beginScopeLabel, endScopeLabel);
                super.visitVarInsn(58, typeNameIndex);
                super.visitVarInsn(25, dimsArrayIndex);
                super.visitMethodInsn(opcode, owner, name, signature);
                super.visitInsn(89);
                super.visitVarInsn(21, productIndex);
                super.visitInsn(95);
                super.visitVarInsn(25, typeNameIndex);
                super.visitLabel(endScopeLabel);
                super.visitInsn(95);
                super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, RECORDER_SIGNATURE);
                return;
            }
        }
        if (opcode == 182) {
            if ("clone".equals(name) && owner.startsWith("[")) {
                int i;
                System.err.println(owner);
                super.visitMethodInsn(opcode, owner, name, signature);
                super.visitInsn(89);
                super.visitTypeInsn(192, owner);
                for (i = 0; i < owner.length() && owner.charAt(i) == '['; ++i) {
                }
                if (i > 1) {
                    this.calculateArrayLengthAndDispatch(owner.substring(i), i);
                } else {
                    super.visitInsn(89);
                    super.visitInsn(190);
                    super.visitInsn(95);
                    this.invokeRecordAllocation(owner.substring(i));
                }
                return;
            }
            if ("newInstance".equals(name)) {
                if ("java/lang/Class".equals(owner) && "()Ljava/lang/Object;".equals(signature)) {
                    super.visitInsn(89);
                    super.visitMethodInsn(opcode, owner, name, signature);
                    super.visitInsn(90);
                    super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, CLASS_RECORDER_SIG);
                    return;
                }
                if ("java/lang/reflect/Constructor".equals(owner) && "([Ljava/lang/Object;)Ljava/lang/Object;".equals(signature)) {
                    this.buildRecorderFromObject(opcode, owner, name, signature);
                    return;
                }
            }
        }
        if (opcode == 183) {
            if ("clone".equals(name) && "java/lang/Object".equals(owner)) {
                this.buildRecorderFromObject(opcode, owner, name, signature);
                return;
            }
            if ("<init>".equals(name) && this.outstandingAllocs > 0) {
                --this.outstandingAllocs;
                this.dupStackElementBeforeSignatureArgs(signature);
                super.visitMethodInsn(opcode, owner, name, signature);
                super.visitLdcInsn((Object)-1);
                super.visitInsn(95);
                this.invokeRecordAllocation(owner);
                super.visitInsn(87);
                return;
            }
        }
        super.visitMethodInsn(opcode, owner, name, signature);
    }

    private void buildRecorderFromObject(int opcode, String owner, String name, String signature) {
        super.visitMethodInsn(opcode, owner, name, signature);
        super.visitInsn(89);
        super.visitInsn(89);
        super.visitMethodInsn(182, "java/lang/Object", "getClass", "()Ljava/lang/Class;");
        super.visitInsn(95);
        super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, CLASS_RECORDER_SIG);
    }

    private void dupStackElementBeforeSignatureArgs(String sig) {
        int i;
        Label beginScopeLabel = new Label();
        Label endScopeLabel = new Label();
        super.visitLabel(beginScopeLabel);
        Type[] argTypes = Type.getArgumentTypes((String)sig);
        int[] args = new int[argTypes.length];
        for (i = argTypes.length - 1; i >= 0; --i) {
            args[i] = this.newLocal(argTypes[i], beginScopeLabel, endScopeLabel);
            super.visitVarInsn(argTypes[i].getOpcode(54), args[i]);
        }
        super.visitInsn(89);
        for (i = 0; i < argTypes.length; ++i) {
            super.visitVarInsn(argTypes[i].getOpcode(21), args[i]);
        }
        super.visitLabel(endScopeLabel);
    }

    public void visitTypeInsn(int opcode, String typeName) {
        if (opcode == 187) {
            super.visitTypeInsn(opcode, typeName);
            ++this.outstandingAllocs;
        } else if (opcode == 189) {
            super.visitInsn(89);
            super.visitTypeInsn(opcode, typeName);
            this.invokeRecordAllocation(typeName);
        } else {
            super.visitTypeInsn(opcode, typeName);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (this.localScopes != null) {
            for (VariableScope scope : this.localScopes) {
                super.visitLocalVariable("xxxxx$" + scope.index, scope.desc, null, scope.start, scope.end, scope.index);
            }
        }
        super.visitMaxs(maxStack, maxLocals);
    }

    private int newLocal(Type type, String typeDesc, Label begin, Label end) {
        int newVar = this.lvs.newLocal(type);
        this.getLocalScopes().add(new VariableScope(newVar, begin, end, typeDesc));
        return newVar;
    }

    private int newLocal(String typeDescriptor, Label begin, Label end) {
        return this.newLocal(Type.getType((String)typeDescriptor), typeDescriptor, begin, end);
    }

    private int newLocal(Type type, Label begin, Label end) {
        return this.newLocal(type, type.getDescriptor(), begin, end);
    }

    private void invokeRecordAllocation(String typeName) {
        typeName = typeName.replaceAll("^\\[*L", "").replaceAll(";$", "");
        super.visitInsn(90);
        super.visitLdcInsn((Object)typeName);
        super.visitInsn(95);
        super.visitMethodInsn(184, this.recorderClass, this.recorderMethod, RECORDER_SIGNATURE);
    }

    public void visitMultiANewArrayInsn(String typeName, int dimCount) {
        super.visitMultiANewArrayInsn(typeName, dimCount);
        this.calculateArrayLengthAndDispatch(typeName, dimCount);
    }

    void calculateArrayLengthAndDispatch(String typeName, int dimCount) {
        Label zeroDimension = new Label();
        super.visitInsn(89);
        super.visitLdcInsn((Object)1);
        for (int i = 0; i < dimCount; ++i) {
            super.visitInsn(95);
            super.visitInsn(90);
            super.visitInsn(190);
            Label nonZeroDimension = new Label();
            super.visitInsn(89);
            super.visitJumpInsn(154, nonZeroDimension);
            super.visitInsn(87);
            super.visitJumpInsn(167, zeroDimension);
            super.visitLabel(nonZeroDimension);
            super.visitInsn(104);
            if (i >= dimCount - 1) continue;
            super.visitInsn(95);
            super.visitInsn(3);
            super.visitInsn(50);
            super.visitInsn(95);
        }
        super.visitLabel(zeroDimension);
        super.visitInsn(95);
        super.visitInsn(87);
        super.visitInsn(95);
        this.invokeRecordAllocation(typeName);
    }

    private static class VariableScope {
        public final int index;
        public final Label start;
        public final Label end;
        public final String desc;

        public VariableScope(int index, Label start, Label end, String desc) {
            this.index = index;
            this.start = start;
            this.end = end;
            this.desc = desc;
        }
    }
}

