/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.CodeSizeEvaluator;

public class VerifyingClassAdapter
extends ClassAdapter {
    private static final Logger logger = Logger.getLogger(VerifyingClassAdapter.class.getName());
    final ClassWriter cw;
    final byte[] original;
    final String className;
    String message = "The class has not finished being examined";
    State state = State.UNKNOWN;

    public VerifyingClassAdapter(ClassWriter cw, byte[] original, String className) {
        super((ClassVisitor)cw);
        this.cw = cw;
        this.original = original;
        this.className = className.replace('/', '.');
    }

    public MethodVisitor visitMethod(int access, final String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        return new CodeSizeEvaluator(mv){

            public void visitEnd() {
                super.visitEnd();
                if (this.getMaxSize() > 65536) {
                    VerifyingClassAdapter.this.state = State.FAIL_TOO_LONG;
                    VerifyingClassAdapter.this.message = "the method " + name + " was too long.";
                }
            }
        };
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.state == State.UNKNOWN) {
            this.state = State.PASS;
        }
    }

    public boolean isVerified() {
        return this.state == State.PASS;
    }

    public byte[] toByteArray() {
        if (this.state != State.PASS) {
            logger.log(Level.WARNING, "Failed to instrument class " + this.className + " because " + this.message);
            return this.original;
        }
        return this.cw.toByteArray();
    }

    public static enum State {
        PASS,
        UNKNOWN,
        FAIL_TOO_LONG;

    }
}

