/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_replacer_plugin;

import com.google.code.maven_replacer_plugin.ReplacerMojo;
import com.google.code.maven_replacer_plugin.file.FileUtils;
import java.io.File;

public class OutputFilenameBuilder {
    private final FileUtils fileUtils = new FileUtils();

    public String buildFrom(String inputFilename, ReplacerMojo mojo) {
        if (mojo.getOutputDir() != null) {
            String result;
            String string = result = mojo.isPreserveDir() ? inputFilename : this.stripPath(inputFilename);
            if (mojo.getOutputBasedir() != null) {
                return this.fileUtils.createFullPath(mojo.getOutputBasedir(), mojo.getOutputDir(), result);
            }
            return this.fileUtils.createFullPath(mojo.getBasedir(), mojo.getOutputDir(), result);
        }
        if (mojo.getOutputFile() != null) {
            File outFile = new File(mojo.getOutputFile());
            if (outFile.isAbsolute()) {
                return this.fileUtils.createFullPath(mojo.getOutputFile());
            }
            return this.fileUtils.createFullPath(mojo.getBasedir(), mojo.getOutputFile());
        }
        return this.fileUtils.createFullPath(mojo.getBasedir(), inputFilename);
    }

    private String stripPath(String inputFilename) {
        return new File(inputFilename).getName();
    }
}

