/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava;

import java.io.File;
import java.net.URI;
import java.util.Collections;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.AbstractSvnScmProvider;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.add.SvnJavaAddCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.blame.SvnJavaBlameCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.branch.SvnJavaBranchCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.changelog.SvnJavaChangeLogCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.checkin.SvnJavaCheckInCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.checkout.SvnJavaCheckOutCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.diff.SvnJavaDiffCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.export.SvnJavaExportCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.info.SvnJavaInfoCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.mkdir.SvnJavaMkdirCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.remove.SvnJavaRemoveCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.status.SvnJavaStatusCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.tag.SvnTagCommand;
import org.apache.maven.scm.provider.svn.svnjava.command.update.SvnJavaUpdateCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;

public class SvnJavaScmProvider
extends AbstractSvnScmProvider {
    public static final String COMMAND_LINE = "JavaSVN Library";
    private static boolean initialized = false;

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        SvnJavaScmProvider.initialize();
        try {
            File f;
            if (scmSpecificUrl.trim().startsWith("file")) {
                try {
                    f = new File(new URI(scmSpecificUrl));
                }
                catch (Exception e) {
                    f = new File(scmSpecificUrl);
                }
            } else {
                f = new File(scmSpecificUrl);
            }
            SVNURL url = f.exists() ? SVNURL.fromFile((File)f) : SVNURL.parseURIEncoded((String)scmSpecificUrl);
            String strUrl = url.toString();
            if (url.getUserInfo() != null) {
                strUrl = StringUtils.replace((String)strUrl, (String)(url.getUserInfo() + "@"), (String)"");
            }
            return new SvnJavaScmProviderRepository(url, strUrl);
        }
        catch (SVNException e) {
            throw new ScmRepositoryException("The scm url is invalid: " + e.getMessage(), Collections.singletonList(e.getMessage()));
        }
    }

    protected SvnCommand getAddCommand() {
        return new SvnJavaAddCommand();
    }

    protected SvnCommand getChangeLogCommand() {
        return new SvnJavaChangeLogCommand();
    }

    protected SvnCommand getCheckInCommand() {
        return new SvnJavaCheckInCommand();
    }

    protected SvnCommand getCheckOutCommand() {
        return new SvnJavaCheckOutCommand();
    }

    protected SvnCommand getDiffCommand() {
        return new SvnJavaDiffCommand();
    }

    protected SvnCommand getRemoveCommand() {
        return new SvnJavaRemoveCommand();
    }

    protected SvnCommand getStatusCommand() {
        return new SvnJavaStatusCommand();
    }

    protected SvnCommand getTagCommand() {
        return new SvnTagCommand();
    }

    protected SvnCommand getUpdateCommand() {
        return new SvnJavaUpdateCommand();
    }

    protected SvnCommand getBranchCommand() {
        return new SvnJavaBranchCommand();
    }

    protected SvnCommand getExportCommand() {
        return new SvnJavaExportCommand();
    }

    protected SvnCommand getInfoCommand() {
        return new SvnJavaInfoCommand();
    }

    protected SvnCommand getListCommand() {
        throw new UnsupportedOperationException("getListCommand() is not implemented");
    }

    protected SvnCommand getBlameCommand() {
        return new SvnJavaBlameCommand();
    }

    protected String getRepositoryURL(File path) throws ScmException {
        try {
            return SVNURL.fromFile((File)path).getURIEncodedPath();
        }
        catch (SVNException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
        initialized = true;
    }

    protected SvnCommand getMkdirCommand() {
        return new SvnJavaMkdirCommand();
    }
}

