/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.info;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;

public class SvnJavaInfoCommand
extends AbstractCommand
implements SvnCommand {
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return this.executeInfoCommand(repository, fileSet, parameters, false, "");
    }

    public InfoScmResult executeInfoCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters, boolean recursive, String revision) throws ScmException {
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repository;
        ArrayList<InfoItem> infoItems = new ArrayList<InfoItem>();
        InfoScmResult svnInfoScmResult = new InfoScmResult(null, infoItems);
        Iterator i = fileSet.getFileList().iterator();
        if (i.hasNext()) {
            while (i.hasNext()) {
                InfoItem currentItem = this.executeSingleInfoCommand(javaRepo, (File)i.next(), revision);
                infoItems.add(currentItem);
            }
        } else {
            InfoItem currentItem = this.executeSingleInfoCommand(javaRepo, fileSet.getBasedir(), revision);
            infoItems.add(currentItem);
        }
        return svnInfoScmResult;
    }

    private InfoItem executeSingleInfoCommand(SvnJavaScmProviderRepository javaRepo, File f, String revision) throws ScmException {
        try {
            SVNRevision svnRev = null;
            if (revision != null) {
                svnRev = SVNRevision.parse((String)revision);
            }
            SVNInfo svnInfo = null;
            boolean isVersionedDirectory = SvnOperationFactory.isVersionedDirectory((File)f);
            this.logger.debug("Get info, isVersionedDirectory: " + isVersionedDirectory);
            if (isVersionedDirectory) {
                this.logger.info("Get info from versioned directory: " + f);
                svnInfo = javaRepo.getClientManager().getWCClient().doInfo(f, svnRev);
            } else {
                SVNURL svnUrl = javaRepo.getSvnUrl();
                this.logger.info("Get info from svnUrl: " + svnUrl);
                svnInfo = javaRepo.getClientManager().getWCClient().doInfo(svnUrl, SVNRevision.UNDEFINED, svnRev);
            }
            InfoItem currentItem = new InfoItem();
            currentItem.setRevision(svnInfo.getRevision() != null ? Long.toString(svnInfo.getRevision().getNumber()) : null);
            currentItem.setLastChangedAuthor(svnInfo.getAuthor());
            currentItem.setLastChangedRevision(svnInfo.getCommittedRevision() != null ? Long.toString(svnInfo.getCommittedRevision().getNumber()) : null);
            currentItem.setLastChangedDate(svnInfo.getCommittedDate() != null ? svnInfo.getCommittedDate().toString() : null);
            currentItem.setURL(svnInfo.getURL() != null ? svnInfo.getURL().toString() : null);
            currentItem.setRepositoryUUID(svnInfo.getRepositoryUUID());
            currentItem.setRepositoryRoot(svnInfo.getRepositoryRootURL() != null ? svnInfo.getRepositoryRootURL().toString() : null);
            currentItem.setNodeKind(svnInfo.getKind() != null ? svnInfo.getKind().toString() : null);
            return currentItem;
        }
        catch (SVNException e) {
            throw new ScmException(e.getMessage(), (Throwable)e);
        }
    }
}

