/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnjava.command.untag;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmTagParameters;
import org.apache.maven.scm.ScmUntagParameters;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.untag.AbstractUntagCommand;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.repository.SvnJavaScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnjava.util.ScmFileEventHandler;
import org.apache.maven.scm.provider.svn.svnjava.util.SvnJavaUtil;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;

public class SvnUnTagCommand
extends AbstractUntagCommand
implements SvnCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScmResult executeUntagCommand(ScmProviderRepository repo, ScmFileSet scmFileSet, ScmUntagParameters scmUntagParameters) throws ScmException {
        String tag = scmUntagParameters.getTag();
        if (tag == null || tag.trim().isEmpty()) {
            throw new ScmException("tag must be specified");
        }
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        ScmFileEventHandler handler = new ScmFileEventHandler(this.logger, scmFileSet.getBasedir());
        javaRepo.getClientManager().getWCClient().setEventHandler((ISVNEventHandler)handler);
        try {
            SVNURL destURL = SVNURL.parseURIEncoded((String)SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)javaRepo, (ScmTag)new ScmTag(tag)));
            javaRepo.getClientManager().getCommitClient().doDelete(new SVNURL[]{destURL}, scmUntagParameters.getMessage());
            UntagScmResult untagScmResult = new UntagScmResult("JavaSVN Library", "The svn remove command was successful.", "", true);
            return untagScmResult;
        }
        catch (SVNException e) {
            UntagScmResult untagScmResult = new UntagScmResult("JavaSVN Library", "SVN remove failed.", e.getMessage(), false);
            return untagScmResult;
        }
        finally {
            javaRepo.getClientManager().getWCClient().setEventHandler(null);
        }
    }

    protected ScmResult executeTagCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag, ScmTagParameters scmTagParameters) throws ScmException {
        if (tag == null) {
            throw new ScmException("tag must be specified");
        }
        if (!fileSet.getFileList().isEmpty()) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SVN checkout directory: " + fileSet.getBasedir().getAbsolutePath());
        }
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        SvnJavaScmProviderRepository javaRepo = (SvnJavaScmProviderRepository)repo;
        try {
            List files;
            SVNCommitInfo info;
            SVNURL destURL = SVNURL.parseURIEncoded((String)SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (ScmTag)new ScmTag(tag)));
            String message = "[maven-scm] copy for tag " + tag;
            if (StringUtils.isNotBlank((String)scmTagParameters.getMessage())) {
                message = scmTagParameters.getMessage();
            }
            if ((info = scmTagParameters != null && scmTagParameters.isRemoteTagging() ? SvnJavaUtil.copy(javaRepo.getClientManager(), javaRepo.getSvnUrl(), destURL, false, message, scmTagParameters.getScmRevision()) : SvnJavaUtil.copy(javaRepo.getClientManager(), fileSet.getBasedir(), destURL, false, message, scmTagParameters.getScmRevision())).getErrorMessage() != null) {
                return new TagScmResult("JavaSVN Library", "SVN tag failed.", info.getErrorMessage().getMessage(), false);
            }
            try {
                files = FileUtils.getFiles((File)fileSet.getBasedir(), (String)"**", (String)"**/.svn/**", (boolean)false);
            }
            catch (IOException e) {
                throw new ScmException("Error while building list of tagged files.", (Throwable)e);
            }
            List fileList = files.stream().map(f -> new ScmFile(f.getPath(), ScmFileStatus.TAGGED)).collect(Collectors.toList());
            return new TagScmResult("JavaSVN Library", fileList);
        }
        catch (SVNException e) {
            return new TagScmResult("JavaSVN Library", "SVN tag failed.", e.getMessage(), false);
        }
    }
}

