/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.maven_svn_revision_number_plugin;

import com.google.code.maven_svn_revision_number_plugin.Entry;
import com.google.code.maven_svn_revision_number_plugin.EntryStatusSymbols;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetInfo;
import org.tmatesoft.svn.core.wc2.SvnGetStatus;
import org.tmatesoft.svn.core.wc2.SvnInfo;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionMojo
extends AbstractMojo {
    private MavenProject project;
    private Entry[] entries;
    private boolean verbose;
    private boolean failOnError;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.entries == null || this.entries.length == 0) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)"configuration/entries is not specified or empty, using default entry");
            }
            this.entries = new Entry[]{new Entry(this.project.getBasedir(), this.project.getArtifactId())};
        }
        for (Entry entry : this.entries) {
            if (entry.getPath() == null) {
                entry.setPath(this.project.getBasedir());
            }
            if (entry.getPrefix() == null) {
                entry.setPrefix(this.project.getArtifactId());
            }
            this.processEntry(entry);
        }
    }

    private void processEntry(Entry entry) throws MojoExecutionException {
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)String.format("inspecting %s %s", entry.getPath().isFile() ? "file" : (entry.getPath().isDirectory() ? "directory" : "path"), entry.getPath()));
        }
        this.logDebugInfo(String.format("  prefix = %s", entry.getPrefix()));
        this.logDebugInfo(String.format("  depth = %s", entry.getDepth()));
        this.logDebugInfo(String.format("  report unversioned = %s", entry.reportUnversioned()));
        this.logDebugInfo(String.format("  report ignored = %s", entry.reportIgnored()));
        this.logDebugInfo(String.format("  report out-of-date = %s", entry.reportOutOfDate()));
        this.logDebugInfo("calculating properties");
        SvnOperationFactory operationFactory = new SvnOperationFactory();
        StatusHandler statusHandler = new StatusHandler(entry);
        try {
            this.logDebugInfo(String.format("  wc format = %s", SvnOperationFactory.detectWcGeneration((File)entry.getPath(), (boolean)true)));
            this.fillStatus(entry, operationFactory, statusHandler);
            this.fillInfo(entry, operationFactory, statusHandler);
        }
        catch (SVNException e) {
            if (e.getErrorMessage() != null && (SVNErrorCode.WC_NOT_WORKING_COPY.equals((Object)e.getErrorMessage().getErrorCode()) || SVNErrorCode.WC_PATH_NOT_FOUND.equals((Object)e.getErrorMessage().getErrorCode()))) {
                statusHandler.resetProperties(true);
            }
            if (this.failOnError) {
                throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
            }
            if (this.getLog().isErrorEnabled()) {
                this.getLog().error((Throwable)e);
            }
            statusHandler.resetProperties();
        }
        this.setProjectProperties(entry.getPrefix(), statusHandler.createProperties());
    }

    private void fillStatus(Entry entry, SvnOperationFactory operationFactory, StatusHandler statusHandler) throws SVNException {
        SvnGetStatus statusOperation = operationFactory.createGetStatus();
        statusOperation.setSingleTarget(SvnTarget.fromFile((File)entry.getPath()));
        statusOperation.setDepth(SVNDepth.fromString((String)entry.getDepth()));
        statusOperation.setRevision(SVNRevision.WORKING);
        statusOperation.setReportAll(true);
        statusOperation.setReportIgnored(entry.reportIgnored());
        statusOperation.setRemote(entry.reportOutOfDate());
        statusOperation.setReceiver((ISvnObjectReceiver)statusHandler);
        statusOperation.run();
    }

    private void fillInfo(Entry entry, SvnOperationFactory operationFactory, StatusHandler statusHandler) throws SVNException {
        if (statusHandler.repositoryPath == null || statusHandler.repositoryPath.length() == 0) {
            SvnGetInfo infoOperation = operationFactory.createGetInfo();
            infoOperation.setSingleTarget(SvnTarget.fromFile((File)entry.getPath()));
            SvnInfo infoResult = (SvnInfo)infoOperation.run();
            statusHandler.repositoryRoot = infoResult.getRepositoryRootUrl().toString();
            statusHandler.repositoryPath = infoResult.getUrl().toString().substring(statusHandler.repositoryRoot.length() + 1);
        }
    }

    private void setProjectProperties(String prefix, Map<String, Object> properties) {
        this.logDebugInfo("setting properties");
        for (Map.Entry<String, Object> entryProperty : properties.entrySet()) {
            this.setProjectProperty(prefix + '.' + entryProperty.getKey(), String.valueOf(entryProperty.getValue()));
        }
    }

    private void setProjectProperty(String name, String value) {
        Properties projectProperties = this.project.getProperties();
        if (projectProperties.getProperty(name) != null) {
            this.logDebugWarning(String.format("the \"%s\" property is already defined and will be overwritten. The possible causes for this are:%n  - the plugin configuration contains two or more entries with the same prefix.%n  - the plugin runs multiple times with the same configuration.%n  - the property is already defined in the POM or by some other plugin.", name));
        }
        projectProperties.setProperty(name, value);
        this.logDebugInfo(String.format("  %s = %s", name, value));
    }

    private void logDebugInfo(CharSequence message) {
        if (this.verbose) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info(message);
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(message);
        }
    }

    private void logDebugWarning(CharSequence message) {
        if (this.verbose) {
            if (this.getLog().isWarnEnabled()) {
                this.getLog().warn(message);
            }
        } else if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(message);
        }
    }

    static {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class StatusHandler
    implements ISvnObjectReceiver<SvnStatus> {
        private final Entry entry;
        private String repositoryRoot;
        private String repositoryPath;
        private long maximumRevision;
        private long minimumRevision;
        private long committedRevision;
        private Date committedDate;
        private Set<SVNStatusType> localStatusTypes;
        private boolean outOfDate;

        private StatusHandler(Entry entry) {
            if (entry == null) {
                throw new IllegalArgumentException("{entry} is null");
            }
            this.entry = entry;
            this.resetProperties();
        }

        public void receive(SvnTarget target, SvnStatus status) throws SVNException {
            long targetCommittedRevision;
            long targetRevision;
            RevisionMojo.this.logDebugInfo(String.format("  %s%s%s %s%s%s  %6s %6s %6s  %s (%s %s)", Character.valueOf(status.getNodeStatus().getCode()), Character.valueOf(status.getPropertiesStatus().getCode()), Character.valueOf(status.getTextStatus().getCode()), Character.valueOf(status.getRepositoryNodeStatus().getCode()), Character.valueOf(status.getRepositoryPropertiesStatus().getCode()), Character.valueOf(status.getRepositoryTextStatus().getCode()), status.getRevision(), status.getChangedRevision(), status.getRepositoryChangedRevision(), target.getPathOrUrlString(), status.getRepositoryRootUrl(), status.getRepositoryRelativePath()));
            if (this.repositoryRoot == null) {
                this.repositoryRoot = status.getRepositoryRootUrl() == null ? "" : status.getRepositoryRootUrl().toString();
                this.repositoryPath = status.getRepositoryRelativePath();
            }
            if ((targetRevision = status.getRevision()) >= 0L) {
                if (this.maximumRevision < targetRevision) {
                    this.maximumRevision = targetRevision;
                }
                if (targetRevision > 0L && this.minimumRevision > targetRevision) {
                    this.minimumRevision = targetRevision;
                }
            }
            if ((targetCommittedRevision = status.getChangedRevision()) >= 0L && this.committedRevision < targetCommittedRevision) {
                this.committedRevision = targetCommittedRevision;
                this.committedDate = status.getChangedDate();
            }
            this.localStatusTypes.add(status.getNodeStatus());
            if (SVNStatusType.STATUS_NORMAL.equals(status.getNodeStatus())) {
                this.localStatusTypes.add(status.getPropertiesStatus());
            }
            if (status.getRepositoryChangedRevision() > targetCommittedRevision) {
                this.outOfDate = true;
            }
        }

        public void resetProperties() {
            this.resetProperties(false);
        }

        public void resetProperties(boolean forceUnversioned) {
            this.repositoryRoot = null;
            this.repositoryPath = null;
            this.maximumRevision = Long.MIN_VALUE;
            this.minimumRevision = Long.MAX_VALUE;
            this.committedRevision = Long.MIN_VALUE;
            this.committedDate = null;
            this.localStatusTypes = new HashSet<SVNStatusType>();
            this.outOfDate = false;
            if (forceUnversioned) {
                this.localStatusTypes.add(SVNStatusType.STATUS_UNVERSIONED);
            }
        }

        public Map<String, Object> createProperties() {
            LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
            properties.put("repository", this.repositoryRoot == null ? "" : this.repositoryRoot);
            properties.put("path", this.repositoryPath == null ? "" : this.repositoryPath);
            properties.put("revision", this.maximumRevision == Long.MIN_VALUE ? -1L : this.maximumRevision);
            properties.put("mixedRevisions", this.maximumRevision > 0L && this.minimumRevision > 0L && this.maximumRevision != this.minimumRevision);
            properties.put("committedRevision", this.committedRevision == Long.MIN_VALUE ? -1L : this.committedRevision);
            properties.put("committedDate", this.committedDate == null ? "" : String.format(Locale.ENGLISH, "%tF %<tT %<tz (%<ta, %<td %<tb %<tY)", this.committedDate));
            properties.put("status", this.createStatusString(EntryStatusSymbols.DEFAULT));
            properties.put("specialStatus", this.createStatusString(EntryStatusSymbols.SPECIAL));
            return properties;
        }

        private String createStatusString(EntryStatusSymbols symbols) {
            StringBuilder status = new StringBuilder();
            HashSet<SVNStatusType> statusTypes = new HashSet<SVNStatusType>(this.localStatusTypes);
            statusTypes.remove(SVNStatusType.STATUS_NONE);
            statusTypes.remove(SVNStatusType.STATUS_NORMAL);
            if (statusTypes.remove(SVNStatusType.STATUS_ADDED)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_ADDED));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_CONFLICTED)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_CONFLICTED));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_DELETED)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_DELETED));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_IGNORED) && this.entry.reportIgnored()) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_IGNORED));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_MODIFIED)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_MODIFIED));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_REPLACED)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_REPLACED));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_EXTERNAL)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_EXTERNAL));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_UNVERSIONED) && this.entry.reportUnversioned()) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_UNVERSIONED));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_MISSING)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_MISSING));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_INCOMPLETE)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_INCOMPLETE));
            }
            if (statusTypes.remove(SVNStatusType.STATUS_OBSTRUCTED)) {
                status.append(symbols.getStatusSymbol(SVNStatusType.STATUS_OBSTRUCTED));
            }
            if (!statusTypes.isEmpty() && RevisionMojo.this.getLog().isWarnEnabled()) {
                RevisionMojo.this.getLog().warn((CharSequence)String.format("the following svn statuses are not taken into account: %s", statusTypes));
            }
            if (this.outOfDate && this.entry.reportOutOfDate()) {
                status.append(symbols.getOutOfDateSymbol());
            }
            return status.toString();
        }
    }
}

