/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper;

import com.googlecode.jmapper.DestinationFactory;
import com.googlecode.jmapper.IMapper;
import com.googlecode.jmapper.api.IJMapper;
import com.googlecode.jmapper.api.JMapperAPI;
import com.googlecode.jmapper.api.enums.MappingType;
import com.googlecode.jmapper.api.enums.NullPointerControl;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.config.JmapperLog;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.generation.MapperBuilder;
import com.googlecode.jmapper.util.GeneralUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JMapper<D, S>
implements IJMapper<D, S> {
    private IMapper<D, S> mapper;

    public D getDestination(S source) {
        try {
            return this.mapper.nullVSouAllAll(source);
        }
        catch (Exception e) {
            JmapperLog.error(e);
            return null;
        }
    }

    public D getDestinationWithoutControl(S source) {
        try {
            return this.mapper.nullVNotAllAll(source);
        }
        catch (Exception e) {
            JmapperLog.error(e);
            return null;
        }
    }

    public D getDestination(D destination, S source) {
        try {
            return this.mapper.vVAllAllAll(destination, source);
        }
        catch (Exception e) {
            JmapperLog.error(e);
            return null;
        }
    }

    public D getDestinationWithoutControl(D destination, S source) {
        try {
            return this.mapper.vVNotAllAll(destination, source);
        }
        catch (Exception e) {
            JmapperLog.error(e);
            return null;
        }
    }

    public D getDestination(S source, MappingType mtSource) {
        return this.getDestination(source, NullPointerControl.SOURCE, mtSource);
    }

    public D getDestination(S source, NullPointerControl nullPointerControl, MappingType mtSource) {
        try {
            switch (nullPointerControl) {
                case ALL: 
                case DESTINATION: 
                case SOURCE: {
                    switch (mtSource) {
                        case ALL_FIELDS: {
                            return this.mapper.nullVSouAllAll(source);
                        }
                        case ONLY_VALUED_FIELDS: {
                            return this.mapper.nullVSouAllValued(source);
                        }
                        case ONLY_NULL_FIELDS: {
                            return this.mapper.get(source);
                        }
                    }
                }
                case NOT_ANY: {
                    switch (mtSource) {
                        case ALL_FIELDS: {
                            return this.mapper.nullVNotAllAll(source);
                        }
                        case ONLY_VALUED_FIELDS: {
                            return this.mapper.nullVNotAllValued(source);
                        }
                        case ONLY_NULL_FIELDS: {
                            return this.mapper.get(source);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return null;
    }

    public D getDestination(D destination, S source, MappingType mtDestination, MappingType mtSource) {
        return this.getDestination(destination, source, NullPointerControl.ALL, mtDestination, mtSource);
    }

    public D getDestination(D destination, S source, NullPointerControl nullPointerControl, MappingType mtDestination, MappingType mtSource) {
        try {
            switch (nullPointerControl) {
                case ALL: {
                    switch (mtDestination) {
                        case ALL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVAllAllAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVAllAllValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVAllValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_VALUED_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVAllValuedAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVAllValuedValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVAllValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_NULL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: 
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVAllNullValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return destination;
                                }
                            }
                        }
                    }
                }
                case DESTINATION: {
                    switch (mtDestination) {
                        case ALL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVDesAllAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVDesAllValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVDesValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_VALUED_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVDesValuedAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVDesValuedValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVDesValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_NULL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: 
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVDesNullValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return destination;
                                }
                            }
                        }
                    }
                }
                case SOURCE: {
                    switch (mtDestination) {
                        case ALL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVSouAllAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVSouAllValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVSouValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_VALUED_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVSouValuedAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVSouValuedValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVSouValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_NULL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: 
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVSouNullValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return destination;
                                }
                            }
                        }
                    }
                }
                case NOT_ANY: {
                    switch (mtDestination) {
                        case ALL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVNotAllAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVNotAllValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVNotValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_VALUED_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: {
                                    return this.mapper.vVNotValuedAll(destination, source);
                                }
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVNotValuedValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return this.mapper.vVNotValuedNull(destination, source);
                                }
                            }
                        }
                        case ONLY_NULL_FIELDS: {
                            switch (mtSource) {
                                case ALL_FIELDS: 
                                case ONLY_VALUED_FIELDS: {
                                    return this.mapper.vVNotNullValued(destination, source);
                                }
                                case ONLY_NULL_FIELDS: {
                                    return destination;
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return null;
    }

    public JMapper(Class<D> destination, Class<S> source) {
        this(destination, source, JMapper.undefinedConfig());
    }

    public JMapper(Class<D> destination, Class<S> source, ChooseConfig chooseConfig) {
        this(destination, source, chooseConfig, JMapper.undefinedXML());
    }

    public JMapper(Class<D> destination, Class<S> source, JMapperAPI api) {
        this(destination, source, api.toXStream().toString());
    }

    public JMapper(Class<D> destination, Class<S> source, ChooseConfig config, JMapperAPI api) {
        this(destination, source, config, api.toXStream().toString());
    }

    public JMapper(Class<D> destination, Class<S> source, String xml) {
        this(destination, source, null, xml);
    }

    public JMapper(Class<D> destination, Class<S> source, ChooseConfig config, String xml) {
        try {
            if (GeneralUtility.isNull(destination)) {
                Error.nullMappedClass("Destination");
            }
            if (GeneralUtility.isNull(source)) {
                Error.nullMappedClass("Source");
            }
            if (destination.isInterface()) {
                Error.interfaceClass("Destination");
            }
            if (source.isInterface()) {
                Error.interfaceClass("Source");
            }
            this.mapper = JMapper.createMapper(MapperBuilder.from(source).to(destination).analyzing(config).presentIn(xml));
        }
        catch (Throwable e) {
            JmapperLog.error(e);
        }
    }

    private static synchronized <D, S> IMapper<D, S> createMapper(MapperBuilder mapper) throws Throwable {
        Class mapperClass = mapper.exist() ? mapper.get() : mapper.generate();
        return mapperClass.newInstance();
    }

    private static ChooseConfig undefinedConfig() {
        return null;
    }

    private static String undefinedXML() {
        return null;
    }

    public JMapper<D, S> destinationFactory(DestinationFactory<D> factory) {
        this.mapper.setDestinationFactory(factory);
        return this;
    }
}

