/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper;

import com.googlecode.jmapper.JMapper;
import com.googlecode.jmapper.annotations.Annotation;
import com.googlecode.jmapper.annotations.JGlobalMap;
import com.googlecode.jmapper.annotations.JMap;
import com.googlecode.jmapper.api.IRelationalJMapper;
import com.googlecode.jmapper.api.JMapperAPI;
import com.googlecode.jmapper.api.enums.MappingType;
import com.googlecode.jmapper.api.enums.NullPointerControl;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.config.JmapperLog;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.exceptions.ClassNotMappedException;
import com.googlecode.jmapper.exceptions.MappingErrorException;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.Attribute;
import com.googlecode.jmapper.xml.Global;
import com.googlecode.jmapper.xml.SimplyAttribute;
import com.googlecode.jmapper.xml.XML;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelationalJMapper<T>
implements IRelationalJMapper<T> {
    private Class<T> configuredClass;
    private final HashMap<String, JMapper> relationalOneToManyMapper = new HashMap();
    private final HashMap<String, JMapper> relationalManyToOneMapper = new HashMap();

    public RelationalJMapper(Class<T> configuredClass) {
        this.configuredClass = configuredClass;
        try {
            this.init();
        }
        catch (ClassNotMappedException e) {
            JmapperLog.error(e);
        }
        catch (MappingErrorException e) {
            JmapperLog.error(e);
        }
    }

    public RelationalJMapper(Class<T> configuredClass, JMapperAPI jmapperAPI) {
        this(configuredClass, jmapperAPI.toXStream().toString());
    }

    public RelationalJMapper(Class<T> configuredClass, String xmlPath) {
        this.configuredClass = configuredClass;
        try {
            this.init(xmlPath);
        }
        catch (MalformedURLException e) {
            JmapperLog.error(e);
        }
        catch (IOException e) {
            JmapperLog.error(e);
        }
        catch (ClassNotMappedException e) {
            JmapperLog.error(e);
        }
        catch (MappingErrorException e) {
            JmapperLog.error(e);
        }
    }

    private void init(String xmlPath) throws MalformedURLException, IOException {
        XML xml = new XML(true, xmlPath);
        if (!xml.isInheritedMapped(this.configuredClass)) {
            Error.classNotMapped(this.configuredClass);
        }
        for (Class<?> classe : this.getClasses(xml)) {
            this.relationalManyToOneMapper.put(classe.getName(), new JMapper(this.configuredClass, classe, ChooseConfig.DESTINATION, xmlPath));
            this.relationalOneToManyMapper.put(classe.getName(), new JMapper(classe, this.configuredClass, ChooseConfig.SOURCE, xmlPath));
        }
    }

    private Set<Class<?>> getClasses(XML xml) {
        HashSet result = new HashSet();
        Global global = null;
        for (Class<?> clazz : ClassesManager.getAllsuperClasses(this.configuredClass)) {
            List<Attribute> attributes;
            if (GeneralUtility.isNull(global) && !GeneralUtility.isNull(global = xml.loadGlobals().get(clazz.getName()))) {
                this.addClasses(global.getClasses(), result);
                if (global.getExcluded() != null) {
                    for (Attribute attribute : xml.loadAttributes().get(clazz.getName())) {
                        for (String fieldName : global.getExcluded()) {
                            if (!attribute.getName().equals(fieldName)) continue;
                            this.addClasses(attribute.getClasses(), result, attribute.getName());
                        }
                    }
                }
            }
            if (GeneralUtility.isNull(attributes = xml.loadAttributes().get(clazz.getName()))) continue;
            for (Attribute attribute : attributes) {
                if (!GeneralUtility.isNull(global) && !GeneralUtility.isPresent(global.getExcluded(), attribute.getName()) && (GeneralUtility.isEmpty(global.getAttributes()) || GeneralUtility.isPresent(global.getAttributes(), new SimplyAttribute(attribute.getName())))) continue;
                this.addClasses(attribute.getClasses(), result, attribute.getName());
            }
        }
        return result;
    }

    private void init() {
        if (!Annotation.isInheritedMapped(this.configuredClass)) {
            Error.classNotMapped(this.configuredClass);
        }
        for (Class<?> classe : this.getClasses()) {
            this.relationalManyToOneMapper.put(classe.getName(), new JMapper(this.configuredClass, classe, ChooseConfig.DESTINATION));
            this.relationalOneToManyMapper.put(classe.getName(), new JMapper(classe, this.configuredClass, ChooseConfig.SOURCE));
        }
    }

    private Set<Class<?>> getClasses() {
        HashSet result = new HashSet();
        JGlobalMap jGlobalMap = null;
        for (Class<?> clazz : ClassesManager.getAllsuperClasses(this.configuredClass)) {
            if (!GeneralUtility.isNull(jGlobalMap) || GeneralUtility.isNull(jGlobalMap = clazz.getAnnotation(JGlobalMap.class))) continue;
            this.addClasses(jGlobalMap.classes(), result);
            if (!GeneralUtility.isNull(jGlobalMap.excluded())) {
                for (Field field : ClassesManager.getListOfFields(this.configuredClass)) {
                    JMap jMap = field.getAnnotation(JMap.class);
                    if (GeneralUtility.isNull(jMap)) continue;
                    for (String fieldName : jGlobalMap.excluded()) {
                        if (!field.getName().equals(fieldName)) continue;
                        this.addClasses(jMap.classes(), result, field.getName());
                    }
                }
            }
            return result;
        }
        for (Field field : ClassesManager.getListOfFields(this.configuredClass)) {
            JMap jMap = field.getAnnotation(JMap.class);
            if (GeneralUtility.isNull(jMap)) continue;
            this.addClasses(jMap.classes(), result, field.getName());
        }
        return result;
    }

    private void addClasses(Class<?>[] classes, HashSet<Class<?>> result, String fieldName) {
        if (classes == null || classes.length == 0) {
            Error.classesAbsent(fieldName, this.configuredClass);
        }
        for (Class<?> classe : classes) {
            result.add(classe);
        }
    }

    private void addClasses(Class<?>[] classes, HashSet<Class<?>> result) {
        if (GeneralUtility.isNull(classes) || classes.length == 0) {
            Error.globalClassesAbsent(this.configuredClass);
        }
        for (Class<?> classe : classes) {
            result.add(classe);
        }
    }

    private <I> I logAndReturnNull(Exception exception) {
        JmapperLog.error(exception);
        return null;
    }

    private <I> I destinationClassControl(Exception exception, Class<I> clazz) {
        try {
            if (clazz == null) {
                throw new IllegalArgumentException("it's mandatory define the destination class");
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
            return null;
        }
        return this.logAndReturnNull(exception);
    }

    private <D, S> JMapper<D, S> getJMapper(HashMap<String, JMapper> map, Object source) {
        Class<?> sourceClass = source instanceof Class ? (Class<?>)source : source.getClass();
        JMapper jMapper = map.get(sourceClass.getName());
        if (jMapper == null) {
            Error.classNotMapped(source, this.configuredClass);
        }
        return jMapper;
    }

    public <S> T manyToOne(S source) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestination(source);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <S> T manyToOneWithoutControl(S source) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestinationWithoutControl(source);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <S> T manyToOne(T destination, S source) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestination(destination, source);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <S> T manyToOneWithoutControl(T destination, S source) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestinationWithoutControl(destination, source);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <S> T manyToOne(S source, MappingType mtSource) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestination(source, mtSource);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <S> T manyToOne(S source, NullPointerControl nullPointerControl, MappingType mtSource) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestination(source, nullPointerControl, mtSource);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <S> T manyToOne(T destination, S source, MappingType mtDestination, MappingType mtSource) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestination(destination, source, mtDestination, mtSource);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <S> T manyToOne(T destination, S source, NullPointerControl nullPointerControl, MappingType mtDestination, MappingType mtSource) {
        try {
            return (T)this.getJMapper(this.relationalManyToOneMapper, source).getDestination(destination, source, nullPointerControl, mtDestination, mtSource);
        }
        catch (Exception e) {
            return (T)this.logAndReturnNull(e);
        }
    }

    public <D> D oneToMany(Class<D> destinationClass, T source) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destinationClass).getDestination(source);
        }
        catch (Exception e) {
            return this.destinationClassControl(e, destinationClass);
        }
    }

    public <D> D oneToManyWithoutControl(Class<D> destinationClass, T source) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destinationClass).getDestinationWithoutControl(source);
        }
        catch (Exception e) {
            return this.destinationClassControl(e, destinationClass);
        }
    }

    public <D> D oneToMany(D destination, T source) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destination.getClass()).getDestination(destination, source);
        }
        catch (Exception e) {
            return (D)this.logAndReturnNull(e);
        }
    }

    public <D> D oneToManyWithoutControl(D destination, T source) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destination.getClass()).getDestinationWithoutControl(destination, source);
        }
        catch (Exception e) {
            return (D)this.logAndReturnNull(e);
        }
    }

    public <D> D oneToMany(Class<D> destinationClass, T source, MappingType mtSource) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destinationClass).getDestination(source, mtSource);
        }
        catch (Exception e) {
            return this.destinationClassControl(e, destinationClass);
        }
    }

    public <D> D oneToMany(Class<D> destinationClass, T source, NullPointerControl nullPointerControl, MappingType mtSource) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destinationClass).getDestination(source, nullPointerControl, mtSource);
        }
        catch (Exception e) {
            return this.destinationClassControl(e, destinationClass);
        }
    }

    public <D> D oneToMany(D destination, T source, MappingType mtDestination, MappingType mtSource) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destination.getClass()).getDestination(destination, source, mtDestination, mtSource);
        }
        catch (Exception e) {
            return (D)this.logAndReturnNull(e);
        }
    }

    public <D> D oneToMany(D destination, T source, NullPointerControl nullPointerControl, MappingType mtDestination, MappingType mtSource) {
        try {
            return this.getJMapper(this.relationalOneToManyMapper, destination.getClass()).getDestination(destination, source, nullPointerControl, mtDestination, mtSource);
        }
        catch (Exception e) {
            return (D)this.logAndReturnNull(e);
        }
    }
}

