/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.annotations;

import com.googlecode.jmapper.annotations.JGlobalMap;
import com.googlecode.jmapper.annotations.JMap;
import com.googlecode.jmapper.annotations.JMapAccessor;
import com.googlecode.jmapper.annotations.JMapAccessors;
import com.googlecode.jmapper.annotations.JMapConversion;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.conversions.explicit.ConversionMethod;
import com.googlecode.jmapper.exceptions.ConversionParameterException;
import com.googlecode.jmapper.exceptions.DynamicConversionBodyException;
import com.googlecode.jmapper.exceptions.DynamicConversionMethodException;
import com.googlecode.jmapper.exceptions.DynamicConversionParameterException;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.Converter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Annotation {
    public static void fillOppositeField(Class<?> configuredClass, MappedField configuredField, MappedField targetField) {
        JMapAccessor accessor = Annotation.getClassAccessors(configuredClass, targetField.getValue().getName(), true);
        if (GeneralUtility.isNull(accessor)) {
            accessor = Annotation.getFieldAccessors(configuredClass, configuredField.getValue(), true, targetField.getValue().getName());
        }
        if (GeneralUtility.isNull(accessor)) {
            return;
        }
        if (targetField.getMethod().equals("") && !accessor.get().equals("")) {
            targetField.getMethod(accessor.get());
        }
        if (targetField.setMethod().equals("") && !accessor.set().equals("")) {
            targetField.setMethod(accessor.set());
        }
    }

    public static void fillMappedField(Class<?> configuredClass, MappedField mappedField) {
        JMapAccessor accessor = Annotation.getClassAccessors(configuredClass, mappedField.getValue().getName(), false);
        if (GeneralUtility.isNull(accessor)) {
            accessor = Annotation.getFieldAccessors(configuredClass, mappedField.getValue());
        }
        if (GeneralUtility.isNull(accessor)) {
            return;
        }
        if (mappedField.getMethod().equals("") && !accessor.get().equals("")) {
            mappedField.getMethod(accessor.get());
        }
        if (mappedField.setMethod().equals("") && !accessor.set().equals("")) {
            mappedField.setMethod(accessor.set());
        }
    }

    public static JMapAccessor getFieldAccessors(Class<?> clazz, Field field) {
        return Annotation.getFieldAccessors(clazz, field, false, field.getName(), "");
    }

    private static JMapAccessor getFieldAccessors(Class<?> clazz, Field field, boolean isOpposite, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            JMapAccessor accessor = Annotation.getAccessor(clazz, field.getAnnotations(), fieldName, isOpposite);
            if (GeneralUtility.isNull(accessor)) continue;
            return accessor;
        }
        return null;
    }

    public static JMapAccessor getClassAccessors(Class<?> clazz, String fieldName, boolean isOpposite) {
        return Annotation.getAccessor(clazz, clazz.getAnnotations(), fieldName, isOpposite);
    }

    private static JMapAccessor getAccessor(Class<?> clazz, java.lang.annotation.Annotation[] annotations, String fieldName, boolean isOpposite) {
        for (java.lang.annotation.Annotation annotation : annotations) {
            JMapAccessor jmapAccessor;
            if (annotation.annotationType() == JMapAccessors.class) {
                JMapAccessors jmapAccessors = (JMapAccessors)annotation;
                for (JMapAccessor jmapAccessor2 : jmapAccessors.value()) {
                    if (!Annotation.isValid(jmapAccessor2, fieldName, clazz, isOpposite)) continue;
                    return jmapAccessor2;
                }
            }
            if (annotation.annotationType() != JMapAccessor.class || !Annotation.isValid(jmapAccessor = (JMapAccessor)annotation, fieldName, clazz, isOpposite)) continue;
            return jmapAccessor;
        }
        return null;
    }

    private static boolean isValid(JMapAccessor accessor, String fieldName, Class<?> targetClass, boolean isOpposite) {
        if (GeneralUtility.isEmpty(accessor.classes())) {
            return accessor.name().equals(fieldName);
        }
        for (Class<?> mappedClass : accessor.classes()) {
            if (!accessor.name().equals(fieldName) || !(isOpposite ? mappedClass != targetClass : mappedClass == targetClass)) continue;
            return true;
        }
        return false;
    }

    public static List<ConversionMethod> getConversionMethods(Class<?> clazz) {
        ArrayList<ConversionMethod> conversions = new ArrayList<ConversionMethod>();
        for (Method method : Annotation.getAnnotatedMethods(clazz)) {
            try {
                conversions.add(Converter.toConversionMethod(method));
            }
            catch (ConversionParameterException e) {
                Error.wrongParameterNumber(method.getName(), clazz.getSimpleName());
            }
            catch (DynamicConversionParameterException e) {
                Error.parametersUsageNotAllowed(method.getName(), clazz.getSimpleName());
            }
            catch (DynamicConversionMethodException e) {
                Error.incorrectMethodDefinition(method.getName(), clazz.getSimpleName());
            }
            catch (DynamicConversionBodyException e) {
                Error.incorrectBodyDefinition(method.getName(), clazz.getSimpleName());
            }
        }
        return conversions;
    }

    private static List<Method> getAnnotatedMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : ClassesManager.getAllMethods(clazz)) {
            if (GeneralUtility.isNull(method.getAnnotation(JMapConversion.class))) continue;
            methods.add(method);
        }
        return methods;
    }

    public static boolean isInheritedMapped(Class<?> classToCheck) {
        for (Class<?> clazz : ClassesManager.getAllsuperClasses(classToCheck)) {
            if (GeneralUtility.isNull(clazz.getAnnotation(JGlobalMap.class))) continue;
            return true;
        }
        for (Field field : ClassesManager.getListOfFields(classToCheck)) {
            if (GeneralUtility.isNull(field.getAnnotation(JMap.class))) continue;
            return true;
        }
        return false;
    }
}

