/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.cache;

import com.googlecode.jmapper.JMapper;
import com.googlecode.jmapper.RelationalJMapper;
import com.googlecode.jmapper.api.IJMapper;
import com.googlecode.jmapper.api.IRelationalJMapper;
import com.googlecode.jmapper.api.JMapperAPI;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.FilesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMapperCache {
    private static HashMap<String, IJMapper<?, ?>> mapperCache = new HashMap();
    private static HashMap<String, IRelationalJMapper<?>> relationalMapperCache = new HashMap();

    public static <D, S> IJMapper<D, S> getMapper(Class<D> destination, Class<S> source) {
        return JMapperCache.getMapper(destination, source, JMapperCache.undefinedConfig());
    }

    public static <D, S> IJMapper<D, S> getMapper(Class<D> destination, Class<S> source, ChooseConfig chooseConfig) {
        return JMapperCache.getMapper(destination, source, chooseConfig, JMapperCache.undefinedXML());
    }

    public static <D, S> IJMapper<D, S> getMapper(Class<D> destination, Class<S> source, JMapperAPI api) {
        return JMapperCache.getMapper(destination, source, api.toXStream().toString());
    }

    public static <D, S> IJMapper<D, S> getMapper(Class<D> destination, Class<S> source, ChooseConfig config, JMapperAPI api) {
        return JMapperCache.getMapper(destination, source, config, api.toXStream().toString());
    }

    public static <D, S> IJMapper<D, S> getMapper(Class<D> destination, Class<S> source, String xml) {
        return JMapperCache.getMapper(destination, source, null, xml);
    }

    public static synchronized <D, S> IJMapper<D, S> getMapper(Class<D> destination, Class<S> source, ChooseConfig config, String xml) {
        String mapperName = ClassesManager.mapperClassName(destination, source, xml);
        if (mapperCache.containsKey(mapperName)) {
            return mapperCache.get(mapperName);
        }
        JMapper<D, S> jmapper = new JMapper<D, S>(destination, source, config, xml);
        mapperCache.put(mapperName, jmapper);
        return jmapper;
    }

    public static <T> IRelationalJMapper<T> getRelationalMapper(Class<T> configuredClass) {
        return JMapperCache.getRelationalMapper(configuredClass, JMapperCache.undefinedXML());
    }

    public static <T> IRelationalJMapper<T> getRelationalMapper(Class<T> configuredClass, JMapperAPI jmapperAPI) {
        return JMapperCache.getRelationalMapper(configuredClass, jmapperAPI.toXStream().toString());
    }

    public static synchronized <T> IRelationalJMapper<T> getRelationalMapper(Class<T> configuredClass, String xml) {
        String mapperName = JMapperCache.relationalMapperName(configuredClass, xml);
        if (relationalMapperCache.containsKey(mapperName)) {
            return relationalMapperCache.get(mapperName);
        }
        RelationalJMapper<T> relationalJMapper = !GeneralUtility.isNull(xml) ? new RelationalJMapper<T>(configuredClass, xml) : new RelationalJMapper<T>(configuredClass);
        relationalMapperCache.put(mapperName, relationalJMapper);
        return relationalJMapper;
    }

    private static ChooseConfig undefinedConfig() {
        return null;
    }

    private static String undefinedXML() {
        return null;
    }

    private static String relationalMapperName(Class<?> configuredClass, String resource) {
        String className = configuredClass.getName().replaceAll("\\.", "");
        if (GeneralUtility.isEmpty(resource)) {
            return className;
        }
        if (!FilesManager.isPath(resource)) {
            return GeneralUtility.write(className, String.valueOf(resource.hashCode()));
        }
        String[] dep = resource.split("\\\\");
        if (dep.length <= 1) {
            dep = resource.split("/");
        }
        String xml = dep[dep.length - 1];
        return GeneralUtility.write(className, xml.replaceAll("\\.", "").replaceAll(" ", ""));
    }
}

