/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.config;

import com.googlecode.jmapper.annotations.Annotation;
import com.googlecode.jmapper.annotations.JGlobalMap;
import com.googlecode.jmapper.annotations.JMap;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.Attribute;
import com.googlecode.jmapper.xml.Global;
import com.googlecode.jmapper.xml.SimplyAttribute;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigReader {
    private final Class<?> configuredClass;
    private final Class<?> targetClass;
    private final XML xml;

    public ConfigReader(Class<?> aConfiguredClass, Class<?> aTargetClass, XML aXml) {
        this.configuredClass = aConfiguredClass;
        this.targetClass = aTargetClass;
        this.xml = aXml;
    }

    private String getValue(String value, String mappedFieldName) {
        if (GeneralUtility.isNull(value)) {
            return null;
        }
        return value.equals("") ? mappedFieldName : value;
    }

    private String getValue(List<String> attributes, List<Class<?>> classes, String value, String mappedFieldName, Class<?> configuredClass, Class<?> targetClass) {
        String targetFieldName;
        String regex = this.getValue(value, mappedFieldName);
        String mappedClassName = configuredClass.getSimpleName();
        String targetClassName = targetClass.getSimpleName();
        if (attributes.isEmpty() && classes.isEmpty()) {
            targetFieldName = ClassesManager.fieldName(targetClass, regex);
            if (!GeneralUtility.isNull(targetFieldName)) {
                return targetFieldName;
            }
            Error.mapping(mappedFieldName, mappedClassName, regex, targetClassName);
        }
        if (attributes.isEmpty() && !classes.isEmpty()) {
            if (classes.contains(targetClass) && !GeneralUtility.isNull(targetFieldName = ClassesManager.fieldName(targetClass, regex))) {
                return targetFieldName;
            }
            Error.mapping(mappedFieldName, mappedClassName, regex, targetClassName);
        }
        if (!attributes.isEmpty() && !classes.isEmpty()) {
            if (attributes.size() == classes.size()) {
                if (classes.contains(targetClass)) {
                    String targetClassValue = attributes.get(classes.indexOf(targetClass));
                    regex = this.getValue(targetClassValue, mappedFieldName);
                    String targetFieldName2 = ClassesManager.fieldName(targetClass, regex);
                    if (!GeneralUtility.isNull(targetFieldName2)) {
                        return targetFieldName2;
                    }
                    Error.mapping(mappedFieldName, mappedClassName, regex, targetClassName);
                } else {
                    Error.mapping(mappedFieldName, mappedClassName, targetClassName);
                }
            } else {
                Error.mapping(mappedFieldName, mappedClassName);
            }
        }
        if (!attributes.isEmpty() && classes.isEmpty()) {
            for (String str : attributes) {
                regex = this.getValue(str, mappedFieldName);
                String targetFieldName3 = ClassesManager.fieldName(targetClass, regex);
                if (GeneralUtility.isNull(targetFieldName3)) continue;
                return targetFieldName3;
            }
        }
        Error.mapping(mappedFieldName, configuredClass, targetClass);
        return "this return is never used";
    }

    public String retrieveTargetFieldName(Field field) {
        JMap jmap;
        String value;
        List<Class<?>> classes = ClassesManager.getAllsuperClasses(this.configuredClass);
        Global global = null;
        for (Class<?> clazz : classes) {
            if (!this.xml.isMapped(clazz)) continue;
            if (GeneralUtility.isNull(global) && !GeneralUtility.isNull(global = this.xml.loadGlobals().get(clazz.getName())) && !GeneralUtility.isPresent(global.getExcluded(), field.getName()) && (GeneralUtility.isEmpty(global.getAttributes()) || GeneralUtility.isPresent(global.getAttributes(), new SimplyAttribute(field.getName())))) {
                List<Class<?>> globalClasses = GeneralUtility.toList(global.getClasses());
                if (!globalClasses.isEmpty() && !globalClasses.contains(this.targetClass)) continue;
                value = global.getValue();
                if (GeneralUtility.isNull(value)) {
                    value = "";
                }
                return this.getValue(Collections.<String>emptyList(), globalClasses, value, field.getName(), clazz, this.targetClass);
            }
            for (Attribute attribute : this.xml.loadAttributes().get(clazz.getName())) {
                List<Class<?>> attributeClasses;
                if (GeneralUtility.isNull(ClassesManager.fieldName(clazz, attribute.getName()))) {
                    Error.attributeAbsent(clazz, attribute);
                }
                if (!attribute.getName().equals(field.getName()) || !(attributeClasses = GeneralUtility.toList(attribute.getClasses())).isEmpty() && !attributeClasses.contains(this.targetClass)) continue;
                ArrayList<String> attributes = new ArrayList<String>();
                if (attribute.getAttributes() != null) {
                    for (SimplyAttribute targetAttribute : attribute.getAttributes()) {
                        attributes.add(targetAttribute.getName());
                    }
                }
                String value2 = null;
                if (!GeneralUtility.isNull(attribute.getValue())) {
                    value2 = attribute.getValue().getName();
                }
                if (GeneralUtility.isNull(value2) && attributes.isEmpty()) {
                    value2 = "";
                }
                return this.getValue(attributes, attributeClasses, value2, field.getName(), clazz, this.targetClass);
            }
        }
        if (this.xml.isInheritedMapped(this.configuredClass)) {
            return "THE_FIELD_IS_NOT_CONFIGURED";
        }
        for (Class<?> clazz : classes) {
            JGlobalMap jglobalMap = clazz.getAnnotation(JGlobalMap.class);
            if (GeneralUtility.isNull(jglobalMap)) continue;
            if (GeneralUtility.isPresent(jglobalMap.excluded(), field.getName()) || !GeneralUtility.isEmpty(jglobalMap.attributes()) && !GeneralUtility.isPresent(jglobalMap.attributes(), field.getName())) break;
            List<Class<?>> globalClasses = GeneralUtility.toList(jglobalMap.classes());
            if (!globalClasses.isEmpty() && !globalClasses.contains(this.targetClass)) {
                return "THE_FIELD_IS_NOT_CONFIGURED";
            }
            String value3 = jglobalMap.value();
            return this.getValue(Collections.<String>emptyList(), globalClasses, value3, field.getName(), this.configuredClass, this.targetClass);
        }
        if (GeneralUtility.isNull(jmap = field.getAnnotation(JMap.class))) {
            return "THE_FIELD_IS_NOT_CONFIGURED";
        }
        List<Class<?>> targetClasses = GeneralUtility.toList(jmap.classes());
        if (!targetClasses.isEmpty() && !targetClasses.contains(this.targetClass)) {
            return "THE_FIELD_IS_NOT_CONFIGURED";
        }
        List<String> attributes = GeneralUtility.toList(jmap.attributes());
        value = jmap.value();
        return this.getValue(attributes, targetClasses, value, field.getName(), this.configuredClass, this.targetClass);
    }

    public void loadAccessors(MappedField configuredField, MappedField targetField) {
        this.loadAccessors(this.targetClass, configuredField, targetField);
    }

    public void loadAccessors(Class<?> targetClass, MappedField configuredField, MappedField targetField) {
        this.xml.fillMappedField(this.configuredClass, configuredField).fillMappedField(targetClass, targetField).fillOppositeField(this.configuredClass, configuredField, targetField);
        Annotation.fillMappedField(this.configuredClass, configuredField);
        Annotation.fillMappedField(targetClass, targetField);
        Annotation.fillOppositeField(this.configuredClass, configuredField, targetField);
    }
}

