/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.conversions.explicit;

import com.googlecode.jmapper.annotations.Annotation;
import com.googlecode.jmapper.conversions.explicit.ConversionMethod;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.enums.ConfigurationType;
import com.googlecode.jmapper.enums.Membership;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionAnalyzer {
    private XML xml;
    private String destinationName;
    private String sourceName;
    private Class<?> destinationClass;
    private Class<?> sourceClass;
    private ChooseConfig config;
    private ConversionMethod method;
    private Membership membership;
    private ConfigurationType configurationType;

    public ConversionAnalyzer(XML xml, ChooseConfig config, Class<?> destinationClass, Class<?> sourceClass) {
        this.xml = xml;
        this.config = config;
        this.destinationClass = destinationClass;
        this.sourceClass = sourceClass;
    }

    public boolean fieldsToCheck(Field destination, Field source) {
        this.destinationName = destination.getName();
        this.sourceName = source.getName();
        if (!this.xml.conversionsLoad().isEmpty()) {
            this.configurationType = ConfigurationType.XML;
            if (this.config == ChooseConfig.DESTINATION) {
                if (this.existsXmlConversion(this.destinationClass)) {
                    this.membership = Membership.DESTINATION;
                    return true;
                }
                if (this.existsXmlConversion(this.sourceClass)) {
                    this.membership = Membership.SOURCE;
                    return true;
                }
            } else {
                if (this.existsXmlConversion(this.sourceClass)) {
                    this.membership = Membership.SOURCE;
                    return true;
                }
                if (this.existsXmlConversion(this.destinationClass)) {
                    this.membership = Membership.DESTINATION;
                    return true;
                }
            }
        }
        this.configurationType = ConfigurationType.ANNOTATION;
        if (this.config == ChooseConfig.DESTINATION) {
            if (this.existsAnnotatedConversion(this.destinationClass)) {
                this.membership = Membership.DESTINATION;
                return true;
            }
            if (this.existsAnnotatedConversion(this.sourceClass)) {
                this.membership = Membership.SOURCE;
                return true;
            }
        } else {
            if (this.existsAnnotatedConversion(this.sourceClass)) {
                this.membership = Membership.SOURCE;
                return true;
            }
            if (this.existsAnnotatedConversion(this.destinationClass)) {
                this.membership = Membership.DESTINATION;
                return true;
            }
        }
        return false;
    }

    public ConversionMethod getMethod() {
        return this.method;
    }

    public Membership getMembership() {
        return this.membership;
    }

    public ConfigurationType getConfigurationType() {
        return this.configurationType;
    }

    private boolean existsAnnotatedConversion(Class<?> clazz) {
        return this.exists(Annotation.getConversionMethods(clazz));
    }

    private boolean existsXmlConversion(Class<?> clazz) {
        return this.exists(this.xml.getConversionMethods(clazz));
    }

    private boolean exists(List<ConversionMethod> conversions) {
        if (conversions.isEmpty()) {
            return false;
        }
        this.method = this.verifyConversionExistence(conversions);
        return this.method != null;
    }

    private ConversionMethod verifyConversionExistence(List<ConversionMethod> conversions) {
        for (ConversionMethod method : conversions) {
            if (!this.isPresentIn(method.getFrom(), this.sourceName) || !this.isPresentIn(method.getTo(), this.destinationName)) continue;
            return method;
        }
        return null;
    }

    private boolean isPresentIn(String[] values, String field) {
        for (String value : values) {
            if (!value.equalsIgnoreCase("all") && !value.equals(field)) continue;
            return true;
        }
        return false;
    }
}

