/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.conversions.explicit;

import com.googlecode.jmapper.annotations.JMapConversion;
import com.googlecode.jmapper.conversions.explicit.ConversionAnalyzer;
import com.googlecode.jmapper.conversions.explicit.ConversionMethod;
import com.googlecode.jmapper.conversions.explicit.ConversionPlaceholder;
import com.googlecode.jmapper.enums.ConfigurationType;
import com.googlecode.jmapper.enums.Membership;
import com.googlecode.jmapper.generation.beans.Method;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.util.FilesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConversionHandler {
    private ConversionMethod methodDefined;
    private Membership membership;
    private ConfigurationType configurationType;
    private Field sourceField;
    private Field destinationField;
    private Method methodToGenerate;
    private HashMap<String, String> placeholders;
    private XML xml;
    private Class<?> sourceClass;
    private Class<?> destinationClass;
    private Class<?> configClass;

    public boolean toBeCreated() {
        return this.configurationType != ConfigurationType.ANNOTATION || this.methodDefined.getType() != JMapConversion.Type.STATIC;
    }

    public Method loadMethod() {
        this.methodToGenerate = new Method();
        this.membership = Membership.MAPPER;
        this.methodToGenerate.setClazz(this.configClass);
        Class<?> destinationClass = this.destinationField.getType();
        Class<?> sourceClass = this.sourceField.getType();
        this.methodToGenerate.setReturnType(destinationClass);
        switch (this.methodDefined.getParameterNumber()) {
            case ZERO: {
                this.methodToGenerate.setParameters(new Class[0]);
                break;
            }
            case ONE: {
                this.methodToGenerate.setParameters(new Class[]{sourceClass});
                break;
            }
            case TWO: {
                this.methodToGenerate.setParameters(new Class[]{destinationClass, sourceClass});
            }
        }
        this.methodToGenerate.setOriginalName(this.methodDefined.getName());
        switch (this.methodDefined.getType()) {
            case STATIC: {
                this.methodToGenerate.setName(this.definedName());
                break;
            }
            case DYNAMIC: {
                this.methodToGenerate.setName(this.dynamicName());
            }
        }
        this.methodDefined.setName(this.methodToGenerate.getName());
        int count = 1;
        String body = "{try{";
        switch (this.methodDefined.getParameterNumber()) {
            case TWO: {
                String dType = this.placeholders.get(ConversionPlaceholder.destinationTypePattern);
                String dName = this.placeholders.get(ConversionPlaceholder.destinationPattern);
                body = body + dType + " " + dName + " = (" + dType + ") $" + count++ + ";" + GeneralUtility.newLine;
            }
            case ONE: {
                String sType = this.placeholders.get(ConversionPlaceholder.sourceTypePattern);
                String sName = this.placeholders.get(ConversionPlaceholder.sourcePattern);
                body = body + sType + " " + sName + " = (" + sType + ") $" + count + ";" + GeneralUtility.newLine;
            }
        }
        body = body + this.methodDefined.getContent();
        for (Map.Entry<String, String> pair : this.placeholders.entrySet()) {
            if (GeneralUtility.isNull(pair.getValue())) continue;
            body = body.replaceAll(pair.getKey(), Matcher.quoteReplacement(pair.getValue()));
        }
        return this.methodToGenerate.setBody(body + "}catch(java.lang.Exception e){" + this.error() + "}return " + this.defaultPrimitiveValue(destinationClass) + ";}");
    }

    private String defaultPrimitiveValue(Class<?> clazz) {
        return clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE ? "0" : (clazz == Long.TYPE ? "0L" : (clazz == Float.TYPE ? "0.0f" : (clazz == Double.TYPE ? "0.0d" : (clazz == Character.TYPE ? "'\u0000'" : (clazz == Boolean.TYPE ? "false" : "null")))));
    }

    private String error() {
        Map<String, List<ConversionMethod>> conversions = this.xml.conversionsLoad();
        String methodName = "illegalCode";
        String paramater = "";
        String resource = this.xml.getXmlPath();
        if (!GeneralUtility.isNull(resource)) {
            boolean isPath = FilesManager.isPath(resource);
            String string = methodName = !isPath ? "illegalCodeContent" : "illegalCode";
            if (!conversions.isEmpty() && !GeneralUtility.isNull(conversions.get(this.configClass.getName()))) {
                if (!isPath) {
                    resource = this.doubleQuotesHandling(resource);
                }
                paramater = GeneralUtility.write(",\"", resource, "\"");
            }
        }
        return GeneralUtility.write("com.googlecode.jmapper.config.Error#", methodName, "(e,\"", this.methodToGenerate.getOriginalName(), "\",\"", this.configClass.getSimpleName(), "\"", paramater, ");");
    }

    private String doubleQuotesHandling(String resource) {
        return resource.replaceAll("\"", Matcher.quoteReplacement("\\\""));
    }

    private String definedName() {
        return this.prefix() + this.methodDefined.getName();
    }

    private String dynamicName() {
        return this.prefix() + "FROM" + this.sourceField.getName() + "TO" + this.destinationField.getName();
    }

    private String prefix() {
        return this.configClass.getSimpleName() + "$";
    }

    public ConversionHandler(XML xml, Class<?> destinationClass, Class<?> sourceClass) {
        this.xml = xml;
        this.destinationClass = destinationClass;
        this.sourceClass = sourceClass;
        this.placeholders = new HashMap();
        this.placeholders.put(ConversionPlaceholder.sourcePattern, "source");
        this.placeholders.put(ConversionPlaceholder.destinationPattern, "destination");
    }

    public ConversionHandler load(ConversionAnalyzer analyzer) {
        this.methodDefined = analyzer.getMethod();
        this.membership = analyzer.getMembership();
        this.configClass = this.membership == Membership.DESTINATION ? this.destinationClass : this.sourceClass;
        this.configurationType = analyzer.getConfigurationType();
        return this;
    }

    public ConversionHandler from(MappedField sourceMappedField) {
        this.sourceField = sourceMappedField.getValue();
        this.placeholders.put(ConversionPlaceholder.sourceTypePattern, this.sourceField.getType().getName());
        this.placeholders.put(ConversionPlaceholder.sourceNamePattern, this.sourceField.getName());
        this.placeholders.put(ConversionPlaceholder.sourceGetPattern, sourceMappedField.getMethod());
        this.placeholders.put(ConversionPlaceholder.sourceSetPattern, sourceMappedField.setMethod());
        return this;
    }

    public ConversionHandler to(MappedField destinationMappedField) {
        this.destinationField = destinationMappedField.getValue();
        this.placeholders.put(ConversionPlaceholder.destinationTypePattern, this.destinationField.getType().getName());
        this.placeholders.put(ConversionPlaceholder.destinationNamePattern, this.destinationField.getName());
        this.placeholders.put(ConversionPlaceholder.destinationGetPattern, destinationMappedField.getMethod());
        this.placeholders.put(ConversionPlaceholder.destinationSetPattern, destinationMappedField.setMethod());
        return this;
    }

    public ConversionMethod getMethod() {
        return this.methodDefined;
    }

    public Membership getMembership() {
        return this.membership;
    }
}

