/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.generation;

import com.googlecode.jmapper.DestinationFactory;
import com.googlecode.jmapper.IMapper;
import com.googlecode.jmapper.Mapper;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.generation.ICodeGenerator;
import com.googlecode.jmapper.generation.beans.Method;
import com.googlecode.jmapper.util.GeneralUtility;
import java.util.List;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.NotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistGenerator
implements ICodeGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> generate(ClassLoader classLoader, String clazzName, List<Method> methods) throws Throwable {
        CtClass cc = null;
        try {
            Class generetedClass;
            ClassPool cp = ClassPool.getDefault();
            cc = cp.makeClass(clazzName);
            cc.setSuperclass(cp.get(Mapper.class.getName()));
            CtNewConstructor.defaultConstructor((CtClass)cc);
            for (Method method : methods) {
                try {
                    Object[] returnTypes = JavassistGenerator.toCtClass(method.getReturnType());
                    CtClass[] parameters = JavassistGenerator.toCtClass(method.getParameters());
                    CtClass returnType = GeneralUtility.isEmpty(returnTypes) ? CtClass.voidType : returnTypes[0];
                    CtMethod ctMethod = new CtMethod(returnType, method.getName(), parameters, cc);
                    cc.addMethod(ctMethod);
                    ctMethod.setBody(method.getBody());
                }
                catch (CannotCompileException e) {
                    Error.bodyContainsIllegalCode(method, (Exception)((Object)e));
                }
            }
            cc.setModifiers(cc.getModifiers() & 0xFFFFFBFF);
            Class clazz = generetedClass = cc.toClass(classLoader, this.getClass().getProtectionDomain());
            return clazz;
        }
        catch (NotFoundException e) {
            Error.notFoundException((Exception)((Object)e));
        }
        finally {
            if (!GeneralUtility.isNull(cc)) {
                cc.defrost();
            }
        }
        return null;
    }

    private static CtClass[] toCtClass(Class<?> ... classes) throws Exception {
        ClassPool cp = ClassPool.getDefault();
        if (GeneralUtility.isEmpty(classes) || GeneralUtility.isNull(classes[0])) {
            return null;
        }
        CtClass[] parameters = new CtClass[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            parameters[i] = cp.get(classes[i].getName());
        }
        return parameters;
    }

    static {
        ClassPool.getDefault().insertClassPath((ClassPath)new ClassClassPath(DestinationFactory.class));
        ClassPool.getDefault().insertClassPath((ClassPath)new ClassClassPath(IMapper.class));
        ClassPool.getDefault().insertClassPath((ClassPath)new ClassClassPath(Mapper.class));
    }
}

