/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.generation;

import com.googlecode.jmapper.Mapper;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.generation.MapperConstructor;
import com.googlecode.jmapper.generation.MapperGenerator;
import com.googlecode.jmapper.generation.beans.Method;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XmlBuilder;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperBuilder {
    private Class<?> destination;
    private Class<?> source;
    private ChooseConfig config;
    private String path;

    public boolean exist() {
        try {
            this.destination.getClassLoader().loadClass(ClassesManager.mapperClassName(this.destination, this.source, this.path));
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public <D, S> Class<Mapper<D, S>> get() {
        try {
            return this.destination.getClassLoader().loadClass(ClassesManager.mapperClassName(this.destination, this.source, this.path));
        }
        catch (Exception e) {
            return null;
        }
    }

    public <D, S> Class<Mapper<D, S>> generate() throws Throwable {
        HashSet<Method> dynamicMethodsToWrite = new HashSet<Method>();
        MapperConstructor mapperConstructor = new MapperConstructor(this.destination, this.source, this.config, XmlBuilder.loadXml(this.path).atRuntime(), dynamicMethodsToWrite).setMapperName(ClassesManager.mapperClassName(this.destination, this.source, this.path));
        Class<Mapper<D, S>> mapperClass = MapperGenerator.generateMapperClass(this.destination.getClassLoader(), mapperConstructor, dynamicMethodsToWrite);
        try {
            mapperClass.newInstance();
        }
        catch (Throwable e) {
            if (GeneralUtility.isNull(this.path)) {
                Error.illegalCode(this.destination, this.source, e);
            }
            Error.illegalCode(this.destination, this.source, this.path, e);
        }
        return mapperClass;
    }

    public static MapperBuilder from(Class<?> source) {
        return new MapperBuilder(source);
    }

    public MapperBuilder to(Class<?> destination) {
        this.destination = destination;
        return this;
    }

    public MapperBuilder analyzing(ChooseConfig config) {
        this.config = config;
        return this;
    }

    public MapperBuilder presentIn(String xmlPath) {
        this.path = xmlPath;
        return this;
    }

    private MapperBuilder(Class<?> source) {
        this.source = source;
    }
}

