/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.generation;

import com.googlecode.jmapper.IMapper;
import com.googlecode.jmapper.api.enums.MappingType;
import com.googlecode.jmapper.api.enums.NullPointerControl;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.generation.MapperConstructorAccessor;
import com.googlecode.jmapper.generation.beans.Method;
import com.googlecode.jmapper.operations.AGeneralOperation;
import com.googlecode.jmapper.operations.OperationHandler;
import com.googlecode.jmapper.operations.complex.AComplexOperation;
import com.googlecode.jmapper.operations.simple.ASimpleOperation;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperConstructor
extends MapperConstructorAccessor {
    public Map<String, String> getMappings() {
        HashMap<String, String> mappings = new HashMap<String, String>();
        HashMap<String, Boolean> destInstance = new HashMap<String, Boolean>();
        String s = "V";
        destInstance.put("null", true);
        destInstance.put("v", false);
        HashMap<String, NullPointerControl> nullPointer = new HashMap<String, NullPointerControl>();
        nullPointer.put("Not", NullPointerControl.NOT_ANY);
        nullPointer.put("All", NullPointerControl.ALL);
        nullPointer.put("Des", NullPointerControl.DESTINATION);
        nullPointer.put("Sou", NullPointerControl.SOURCE);
        HashMap<String, MappingType> mapping = new HashMap<String, MappingType>();
        mapping.put("All", MappingType.ALL_FIELDS);
        mapping.put("Valued", MappingType.ONLY_VALUED_FIELDS);
        mapping.put("Null", MappingType.ONLY_NULL_FIELDS);
        java.lang.reflect.Method[] methods = IMapper.class.getDeclaredMethods();
        for (Map.Entry d : destInstance.entrySet()) {
            for (Map.Entry npc : nullPointer.entrySet()) {
                for (Map.Entry mtd : mapping.entrySet()) {
                    for (Map.Entry mts : mapping.entrySet()) {
                        String methodName = (String)d.getKey() + s + (String)npc.getKey() + (String)mtd.getKey() + (String)mts.getKey();
                        for (java.lang.reflect.Method method : methods) {
                            if (!method.getName().equals(methodName)) continue;
                            mappings.put(methodName, this.wrappedMapping((Boolean)d.getValue(), (NullPointerControl)npc.getValue(), (MappingType)mtd.getValue(), (MappingType)mts.getValue()));
                        }
                    }
                }
            }
        }
        mappings.put("get", "return null;" + GeneralUtility.newLine);
        return mappings;
    }

    private String wrappedMapping(boolean makeDest, NullPointerControl npc, MappingType mtd, MappingType mts) {
        String sClass = this.source.getName();
        String dClass = this.destination.getName();
        String str = (makeDest ? "   " + sClass + " " + this.stringOfGetSource + " = (" + sClass + ") $1;" : "   " + dClass + " " + this.stringOfGetDestination + " = (" + dClass + ") $1;" + GeneralUtility.newLine + "   " + sClass + " " + this.stringOfGetSource + " = (" + sClass + ") $2;") + GeneralUtility.newLine;
        switch (npc) {
            case SOURCE: {
                str = str + "if(" + this.stringOfGetSource + "!=null){" + GeneralUtility.newLine;
                break;
            }
            case DESTINATION: {
                str = str + "if(" + this.stringOfGetDestination + "!=null){" + GeneralUtility.newLine;
                break;
            }
            case ALL: {
                str = str + "if(" + this.stringOfGetSource + "!=null && " + this.stringOfGetDestination + "!=null){" + GeneralUtility.newLine;
                break;
            }
        }
        str = str + this.mapping(makeDest, mtd, mts) + GeneralUtility.newLine + "   return " + this.stringOfSetDestination + ";" + GeneralUtility.newLine;
        return npc != NullPointerControl.NOT_ANY ? (str = str + "}" + GeneralUtility.newLine + " return null;" + GeneralUtility.newLine) : str;
    }

    private String newInstance(Class<?> destinationClass, String destinationField) {
        String destinationClassName = destinationClass.getName();
        String emptyConstructor = "";
        try {
            destinationClass.newInstance();
            emptyConstructor = GeneralUtility.write("else{", GeneralUtility.newLine, "   ", destinationField, " = new ", destinationClassName, "();", GeneralUtility.newLine, "   }", GeneralUtility.newLine);
        }
        catch (Exception e) {
            emptyConstructor = GeneralUtility.write("else{", GeneralUtility.newLine, "   com.googlecode.jmapper.config.Error#absentFactoryAndEmptyConstructor(\"", destinationClass.getSimpleName(), "\");", GeneralUtility.newLine, "   }", GeneralUtility.newLine);
        }
        return GeneralUtility.write("   ", destinationClassName, " ", destinationField, " = null;", GeneralUtility.newLine, "   if(super.getDestinationFactory()!=null){", GeneralUtility.newLine, "   ", destinationField, " = (", destinationClassName, ") super.getDestinationFactory().make();", GeneralUtility.newLine, "   }", emptyConstructor);
    }

    public StringBuilder mapping(boolean makeDest, MappingType mtd, MappingType mts) {
        StringBuilder sb = new StringBuilder();
        if (this.isNullSetting(makeDest, mtd, mts, sb)) {
            return sb;
        }
        if (makeDest) {
            sb.append(this.newInstance(this.destination, this.stringOfSetDestination));
        }
        for (ASimpleOperation simpleOperation : this.simpleOperations) {
            sb.append((CharSequence)this.setOperation(simpleOperation, mtd, mts).write());
        }
        for (AComplexOperation complexOperation : this.complexOperations) {
            sb.append((CharSequence)this.setOperation(complexOperation, mtd, mts).write(makeDest));
        }
        return sb;
    }

    private <T extends AGeneralOperation> T setOperation(T operation, MappingType mtd, MappingType mts) {
        operation.setMtd(mtd).setMts(mts).initialDSetPath(this.stringOfSetDestination).initialDGetPath(this.stringOfGetDestination).initialSGetPath(this.stringOfGetSource);
        return operation;
    }

    private boolean isNullSetting(boolean makeDest, MappingType mtd, MappingType mts, StringBuilder result) {
        if (makeDest && (mtd == MappingType.ALL_FIELDS || mtd == MappingType.ONLY_VALUED_FIELDS) && mts == MappingType.ONLY_NULL_FIELDS) {
            result.append("   " + this.stringOfSetDestination + "(null);" + GeneralUtility.newLine);
            return true;
        }
        return false;
    }

    public MapperConstructor(Class<?> aDestination, Class<?> aSource, String aStringOfSetDestination, String aStringOfGetDestination, String aStringOfGetSource, ChooseConfig cc, XML xml, Set<Method> dynamicMethodsToWrite) {
        this(aDestination, aSource, cc, xml, dynamicMethodsToWrite);
        this.stringOfSetDestination = aStringOfSetDestination;
        this.stringOfGetDestination = aStringOfGetDestination;
        this.stringOfGetSource = aStringOfGetSource;
    }

    public MapperConstructor(Class<?> aDestination, Class<?> aSource, ChooseConfig configChoice, XML xml, Set<Method> dynamicMethodsToWrite) {
        this.destination = aDestination;
        this.source = aSource;
        ChooseConfig configObtained = this.searchConfig(configChoice, xml);
        if (this.notFound(configObtained)) {
            Class clazz;
            Class clazz2 = clazz = configChoice == ChooseConfig.SOURCE ? this.source : this.destination;
            if (this.notDeclared(configChoice)) {
                if (xml.exists()) {
                    Error.configNotPresent(this.destination, this.source, xml);
                } else {
                    Error.classesNotConfigured(this.destination, this.source);
                }
            }
            if (this.isDeclared(configChoice)) {
                if (xml.exists()) {
                    Error.configNotPresent(clazz, xml);
                } else {
                    Error.classNotConfigured(clazz);
                }
            }
        }
        OperationHandler operationHandler = new OperationHandler(this.destination, this.source, configObtained, xml);
        operationHandler.loadStructures(dynamicMethodsToWrite);
        this.simpleOperations = operationHandler.getSimpleOperations();
        this.complexOperations = operationHandler.getComplexOperations();
    }

    public MapperConstructor setMapperName(String name) {
        this.mapperName = name;
        return this;
    }
}

