/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.generation;

import com.googlecode.jmapper.IMapper;
import com.googlecode.jmapper.generation.ICodeGenerator;
import com.googlecode.jmapper.generation.JavassistGenerator;
import com.googlecode.jmapper.generation.MapperConstructor;
import com.googlecode.jmapper.generation.beans.Method;
import com.googlecode.jmapper.util.GeneralUtility;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapperGenerator {
    private static Set<Class<? extends ICodeGenerator>> generators;

    public static Class<?> generateMapperClass(ClassLoader classLoader, MapperConstructor mapping, Set<Method> dynamicMethods) throws Throwable {
        Map<String, String> mappings = mapping.getMappings();
        ArrayList<Method> methods = new ArrayList<Method>(dynamicMethods);
        for (java.lang.reflect.Method method : IMapper.class.getDeclaredMethods()) {
            if (!mappings.containsKey(method.getName())) continue;
            methods.add(new Method(method.getReturnType(), method.getParameterTypes(), method.getName()).setBody("{" + mappings.get(method.getName()) + "}"));
        }
        String className = mapping.getMapperName();
        if (GeneralUtility.isNull(generators)) {
            generators = new Reflections("com.googlecode.jmapper.generation.impl", new Scanner[0]).getSubTypesOf(ICodeGenerator.class);
        }
        JavassistGenerator generator = generators.isEmpty() ? new JavassistGenerator() : generators.iterator().next().newInstance();
        for (Method method : methods) {
            method.setBody(MapperGenerator.replace(method.getBody()));
        }
        return generator.generate(classLoader, className, methods);
    }

    private static String replace(String str) {
        return str.replaceAll(Pattern.quote("$"), "\\$");
    }
}

