/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations;

import com.googlecode.jmapper.api.enums.MappingType;
import com.googlecode.jmapper.conversions.implicit.ConversionHandler;
import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.operations.AGeneralOperationAccessor;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.operations.info.NestedMappedField;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AGeneralOperation
extends AGeneralOperationAccessor {
    protected StringBuilder getNestedMapping() {
        if (GeneralUtility.isNull(this.nestedMappingInfo)) {
            return null;
        }
        return this.nestedMappingInfo.isSource() ? this.calculateSourceNestedMapping() : this.calculateDestinationNestedMapping();
    }

    private StringBuilder calculateSourceNestedMapping() {
        StringBuilder mapping = new StringBuilder();
        String actualField = this.initialSGetPath;
        int index = 0;
        String nestedField = "nestedField" + ++index;
        for (NestedMappedField nestedMappedField : this.nestedMappingInfo.getNestedFields()) {
            this.tryCatch(mapping, nestedField, actualField, nestedMappedField);
            if (this.nestedMappingInfo.isLastField(nestedMappedField)) break;
            actualField = nestedField;
            nestedField = "nestedField" + ++index;
        }
        this.initialSGetPath = actualField;
        return mapping;
    }

    private void tryCatch(StringBuilder mapping, String nestedField, String actualField, NestedMappedField nestedMappedField) {
        MappedField mappedField = nestedMappedField.getField();
        boolean safeNavigationOperatorDefined = nestedMappedField.isSafeNavigationOperatorDefined();
        Class<?> nestedClass = mappedField.getValue().getType();
        String getField = mappedField.getMethod();
        String destinationClass = this.nestedMappingInfo.getConfiguredClass().getSimpleName();
        String destinationField = this.nestedMappingInfo.getConfiguredField().getName();
        String sourceClass = this.nestedMappingInfo.getFirstNestedClass().getSimpleName();
        String sourceField = this.nestedMappingInfo.getFirstNestedField().getName();
        this.write(mapping, "   ", nestedClass.getName(), " ", nestedField, " = null;", GeneralUtility.newLine, "   try{", GeneralUtility.newLine, "      ", nestedField, " = ", actualField, ".", getField, "();", GeneralUtility.newLine, "   }catch(", NullPointerException.class.getName(), " e){", GeneralUtility.newLine, "      com.googlecode.jmapper.config.Error.nestedBeanNull(\"", mappedField.getName(), "\", \"", destinationClass, "\", \"", destinationField, "\", \"", sourceClass, "\", \"", sourceField, "\", ", safeNavigationOperatorDefined, ");", GeneralUtility.newLine, "   }", GeneralUtility.newLine);
    }

    private StringBuilder calculateDestinationNestedMapping() {
        StringBuilder mapping = new StringBuilder();
        String actualField = this.initialDGetPath;
        int index = 0;
        String nestedField = "nestedField" + ++index;
        for (NestedMappedField nestedMappedField : this.nestedMappingInfo.getNestedFields()) {
            if (this.nestedMappingInfo.isLastField(nestedMappedField)) break;
            MappedField field = nestedMappedField.getField();
            Class<?> nestedClass = field.getValue().getType();
            this.nestedMapping(mapping, nestedClass, nestedField, actualField, field);
            actualField = nestedField;
            nestedField = "nestedField" + ++index;
        }
        this.initialDSetPath = actualField;
        this.initialDGetPath = actualField;
        return mapping;
    }

    private void nestedMapping(StringBuilder mapping, Class<?> nestedClass, String nestedField, String actualField, MappedField mappedField) {
        String getField = mappedField.getMethod();
        String setField = mappedField.setMethod();
        this.write(mapping, "   ", nestedClass.getName(), " ", nestedField, " = ", actualField, ".", getField, "();", GeneralUtility.newLine, "   if(", nestedField, " == null){", GeneralUtility.newLine, "      ", nestedField, " = new ", nestedClass.getName(), "();", GeneralUtility.newLine, "      ", actualField, ".", setField, "(", nestedField, ");", GeneralUtility.newLine, "   }", GeneralUtility.newLine);
    }

    protected final StringBuilder setDestination() {
        return this.write(this.initialDSetPath, ".", this.destinationField.setMethod());
    }

    protected final StringBuilder setDestination(Object content) {
        return this.write("   ", this.setDestination(), "(", content, ");");
    }

    protected final StringBuilder getDestination() {
        return this.write(this.initialDGetPath, ".", this.destinationField.getMethod(), "()");
    }

    protected final StringBuilder getSource() {
        return this.write(this.initialSGetPath, ".", this.sourceField.getMethod(), "()");
    }

    protected final StringBuilder addMappingTypeControl(StringBuilder content) {
        StringBuilder sb = new StringBuilder();
        int openBracket = 0;
        boolean isDPrimitive = this.destinationType().isPrimitive();
        boolean isSPrimitive = this.sourceType().isPrimitive();
        if (!isDPrimitive && this.isNullSetting()) {
            StringBuilder stringBuilder = content = this.avoidSet ? this.write(GeneralUtility.newLine) : this.write(this.setDestination("null"), GeneralUtility.newLine);
        }
        if ((isDPrimitive || isSPrimitive) && this.isNullSetting() || isDPrimitive && this.mtd == MappingType.ONLY_NULL_FIELDS) {
            return this.write(GeneralUtility.newLine);
        }
        if (!isDPrimitive) {
            switch (this.mtd) {
                case ONLY_VALUED_FIELDS: {
                    this.write(sb, "   if(", this.getDestination(), "!=null){", GeneralUtility.newLine);
                    ++openBracket;
                    break;
                }
                case ONLY_NULL_FIELDS: {
                    this.write(sb, "   if(", this.getDestination(), "==null){", GeneralUtility.newLine);
                    ++openBracket;
                }
            }
        }
        if (!isSPrimitive) {
            if (!isDPrimitive) {
                switch (this.mts) {
                    case ONLY_VALUED_FIELDS: {
                        this.write(sb, "   if(", this.getSource(), "!=null){", GeneralUtility.newLine);
                        break;
                    }
                    case ONLY_NULL_FIELDS: {
                        this.write(sb, "   if(", this.getSource(), "==null){", GeneralUtility.newLine);
                        ++openBracket;
                    }
                }
            } else {
                switch (this.mts) {
                    case ONLY_VALUED_FIELDS: {
                        this.write(sb, "   if(", this.getSource(), "!=null){", GeneralUtility.newLine);
                        ++openBracket;
                    }
                }
            }
        }
        sb.append((CharSequence)content);
        while (true) {
            int n = ++openBracket;
            --openBracket;
            if (n <= 0) break;
            this.write(sb, "   }", GeneralUtility.newLine);
        }
        return sb;
    }

    protected final StringBuilder applyExplicitConversion() {
        String conversionMethod = "";
        switch (this.conversionMembership) {
            case MAPPER: {
                conversionMethod = this.conversion.getName();
                break;
            }
            case DESTINATION: {
                conversionMethod = this.initialDGetPath + "." + this.conversion.getName();
                break;
            }
            case SOURCE: {
                conversionMethod = this.initialSGetPath + "." + this.conversion.getName();
                break;
            }
        }
        switch (this.conversion.getParameterNumber()) {
            case ZERO: {
                return this.setDestination(conversionMethod + "()");
            }
            case ONE: {
                return this.setDestination(conversionMethod + "(" + this.getSource() + ")");
            }
            case TWO: {
                String mapping = conversionMethod + "(" + this.getDestination() + ", " + this.getSource() + ")";
                return this.conversion.isAvoidSet() ? new StringBuilder("   " + mapping + ";") : this.setDestination(mapping);
            }
        }
        return null;
    }

    protected final Object applyImplicitConversion(ConversionType conversionType, Class<?> dClass, Class<?> sClass, Object sourceContent) {
        if (!conversionType.isAbsent()) {
            if (!conversionType.isUndefined()) {
                return ConversionHandler.getConversion(conversionType, sourceContent);
            }
            if (GeneralUtility.isCastCase(dClass, sClass)) {
                return this.write("(", dClass.getName(), ")", sourceContent);
            }
        } else {
            if (ClassesManager.isBoxing(dClass, sClass)) {
                return this.write("new ", dClass.getName(), "(", sourceContent, ")");
            }
            if (ClassesManager.isUnBoxing(dClass, sClass)) {
                return this.write(sourceContent, ".", dClass.getName(), "Value()");
            }
        }
        return sourceContent;
    }

    private boolean isNullSetting() {
        return this.mts == MappingType.ONLY_NULL_FIELDS;
    }

    protected boolean theSourceIsToBeConverted() {
        return !this.info.getConversionType().isAbsent();
    }
}

