/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations;

import com.googlecode.jmapper.annotations.Annotation;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.exceptions.InvalidNestedMappingException;
import com.googlecode.jmapper.exceptions.MappingException;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.operations.info.NestedMappedField;
import com.googlecode.jmapper.operations.info.NestedMappingInfo;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedMappingHandler {
    public static boolean isNestedMapping(String regex) {
        return regex.startsWith("${") && regex.endsWith("}");
    }

    public static String[] nestedFields(String nestedMappingPath) {
        return nestedMappingPath.substring("${".length(), nestedMappingPath.length() - "}".length()).split("\\.");
    }

    public static boolean safeNavigationOperatorDefined(String nestedFieldName) {
        if (nestedFieldName.contains("?")) {
            if (!nestedFieldName.startsWith("?")) {
                throw new MappingException("Safe navigation operator must be the first symbol after dot notation");
            }
            return true;
        }
        return false;
    }

    public static String safeNavigationOperatorFilter(String nestedFieldName) {
        return nestedFieldName.replaceAll("\\?", "");
    }

    private static MappedField checkGetAccessor(XML xml, Class<?> aClass, Field nestedField) {
        MappedField field = new MappedField(nestedField);
        xml.fillMappedField(aClass, field);
        Annotation.fillMappedField(aClass, field);
        ClassesManager.verifyGetterMethods(aClass, field);
        return field;
    }

    private static MappedField checkAccessors(XML xml, Class<?> aClass, Field nestedField) {
        MappedField field = NestedMappingHandler.checkGetAccessor(xml, aClass, nestedField);
        ClassesManager.verifySetterMethods(aClass, field);
        return field;
    }

    public static NestedMappingInfo loadNestedMappingInformation(XML xml, Class<?> targetClass, String nestedMappingPath, Class<?> sourceClass, Class<?> destinationClass, Field configuredField) {
        boolean isSourceClass = targetClass == sourceClass;
        NestedMappingInfo info = new NestedMappingInfo(isSourceClass);
        info.setConfiguredClass(isSourceClass ? destinationClass : sourceClass);
        info.setConfiguredField(configuredField);
        try {
            Class<?> nestedClass = targetClass;
            String[] nestedFields = NestedMappingHandler.nestedFields(nestedMappingPath);
            Field field = null;
            for (int i = 0; i < nestedFields.length; ++i) {
                String nestedFieldName = nestedFields[i];
                boolean elvisOperatorDefined = false;
                if (i < nestedFields.length - 1) {
                    String nextNestedFieldName = nestedFields[i + 1];
                    elvisOperatorDefined = NestedMappingHandler.safeNavigationOperatorDefined(nextNestedFieldName);
                }
                if (GeneralUtility.isNull(field = ClassesManager.retrieveField(nestedClass, nestedFieldName = NestedMappingHandler.safeNavigationOperatorFilter(nestedFieldName)))) {
                    Error.inexistentField(nestedFieldName, nestedClass.getSimpleName());
                }
                MappedField nestedField = isSourceClass ? NestedMappingHandler.checkGetAccessor(xml, nestedClass, field) : NestedMappingHandler.checkAccessors(xml, nestedClass, field);
                info.addNestedField(new NestedMappedField(nestedField, nestedClass, elvisOperatorDefined));
                nestedClass = field.getType();
            }
        }
        catch (MappingException e) {
            InvalidNestedMappingException exception = new InvalidNestedMappingException(nestedMappingPath);
            exception.getMessages().put(InvalidNestedMappingException.FIELD, e.getMessage());
            throw exception;
        }
        return info;
    }
}

