/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations;

import com.googlecode.jmapper.conversions.explicit.ConversionAnalyzer;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.analyzer.ArrayAnalyzer;
import com.googlecode.jmapper.operations.analyzer.ArrayListAnalyzer;
import com.googlecode.jmapper.operations.analyzer.BasicAnalyzer;
import com.googlecode.jmapper.operations.analyzer.CollectionAnalyzer;
import com.googlecode.jmapper.operations.analyzer.DateCalendarAnalyzer;
import com.googlecode.jmapper.operations.analyzer.EnumEnumAnalyzer;
import com.googlecode.jmapper.operations.analyzer.MapAnalyzer;
import com.googlecode.jmapper.operations.analyzer.MappedObjectAnalyzer;
import com.googlecode.jmapper.operations.analyzer.StringEnumAnalyzer;
import com.googlecode.jmapper.operations.analyzer.StringStringBufferAnalyzer;
import com.googlecode.jmapper.operations.analyzer.StringStringBuilderAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public final class OperationAnalyzer {
    private List<IOperationAnalyzer> analyzers;
    private ConversionAnalyzer conversionAnalyzer;
    private InfoOperation info;

    public OperationAnalyzer(XML xml, ConversionAnalyzer conversionAnalyzer) {
        this.conversionAnalyzer = conversionAnalyzer;
        this.analyzers = Arrays.asList(new BasicAnalyzer(xml), new ArrayAnalyzer(xml), new MappedObjectAnalyzer(xml), new CollectionAnalyzer(xml), new MapAnalyzer(xml), new ArrayListAnalyzer(xml), new StringStringBuilderAnalyzer(), new StringStringBufferAnalyzer(), new StringEnumAnalyzer(), new DateCalendarAnalyzer(), new EnumEnumAnalyzer());
    }

    public boolean isUndefined(Field destination, Field source) {
        this.info = null;
        for (IOperationAnalyzer analyzer : this.analyzers) {
            if (!analyzer.verifyConditions(destination, source)) continue;
            this.info = analyzer.getInfoOperation(destination, source);
        }
        if (GeneralUtility.isNull(this.info)) {
            this.info = this.undefinedOperation();
        }
        boolean conversionMethodExists = this.conversionAnalyzer.fieldsToCheck(destination, source);
        OperationType operationType = this.info.getOperationType();
        if (operationType.isUndefined() && !conversionMethodExists) {
            return true;
        }
        if (conversionMethodExists) {
            this.info.setInstructionType(operationType.isBasic() ? OperationType.BASIC_CONVERSION : OperationType.CONVERSION);
        }
        return false;
    }

    private InfoOperation undefinedOperation() {
        return new InfoOperation().setInstructionType(OperationType.UNDEFINED);
    }

    public InfoOperation getInfo() {
        return this.info;
    }
}

