/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations;

import com.googlecode.jmapper.config.ConfigReader;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.conversions.explicit.ConversionAnalyzer;
import com.googlecode.jmapper.conversions.explicit.ConversionHandler;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.exceptions.InvalidNestedMappingException;
import com.googlecode.jmapper.generation.beans.Method;
import com.googlecode.jmapper.operations.AGeneralOperation;
import com.googlecode.jmapper.operations.NestedMappingHandler;
import com.googlecode.jmapper.operations.OperationAnalyzer;
import com.googlecode.jmapper.operations.OperationFactory;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.operations.complex.AComplexOperation;
import com.googlecode.jmapper.operations.info.InfoOperation;
import com.googlecode.jmapper.operations.info.NestedMappingInfo;
import com.googlecode.jmapper.operations.recursive.ARecursiveOperation;
import com.googlecode.jmapper.operations.simple.ASimpleOperation;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OperationHandler {
    private List<ASimpleOperation> simpleOperations = new ArrayList<ASimpleOperation>();
    private List<AComplexOperation> complexOperations = new ArrayList<AComplexOperation>();
    private final Class<?> destinationClass;
    private final Class<?> sourceClass;
    private final Class<?> configuredClass;
    private final Class<?> targetClass;
    private final ChooseConfig configurationChosen;
    private final boolean isDestConfigured;
    private final XML xml;
    private final ConfigReader configReader;
    private final OperationAnalyzer operationAnalyzer;
    private final ConversionAnalyzer conversionAnalyzer;
    private final ConversionHandler conversionHandler;

    public OperationHandler(Class<?> aDestinationClass, Class<?> aSourceClass, ChooseConfig aConfigurationChosen, XML aXml) {
        this.xml = aXml;
        this.destinationClass = aDestinationClass;
        this.sourceClass = aSourceClass;
        this.configurationChosen = aConfigurationChosen;
        this.isDestConfigured = this.configurationChosen == ChooseConfig.DESTINATION;
        this.configuredClass = this.isDestConfigured ? this.destinationClass : this.sourceClass;
        this.targetClass = this.isDestConfigured ? this.sourceClass : this.destinationClass;
        this.configReader = new ConfigReader(this.configuredClass, this.targetClass, this.xml);
        this.conversionHandler = new ConversionHandler(this.xml, this.destinationClass, this.sourceClass);
        this.conversionAnalyzer = new ConversionAnalyzer(this.xml, this.configurationChosen, this.destinationClass, this.sourceClass);
        this.operationAnalyzer = new OperationAnalyzer(this.xml, this.conversionAnalyzer);
    }

    public void loadStructures(Set<Method> dynamicMethodsToWrite) {
        for (Field configuredField : ClassesManager.getListOfFields(this.configuredClass)) {
            Field sourceField;
            String targetFieldName = this.configReader.retrieveTargetFieldName(configuredField);
            if (targetFieldName == "THE_FIELD_IS_NOT_CONFIGURED") continue;
            boolean isNestedMapping = NestedMappingHandler.isNestedMapping(targetFieldName);
            Field targetField = null;
            NestedMappingInfo nestedMappingInfo = null;
            if (isNestedMapping) {
                try {
                    nestedMappingInfo = NestedMappingHandler.loadNestedMappingInformation(this.xml, this.targetClass, targetFieldName, this.sourceClass, this.destinationClass, configuredField);
                    targetField = nestedMappingInfo.getLastNestedField();
                }
                catch (InvalidNestedMappingException e) {
                    Error.invalidNestedMapping(this.configuredClass, configuredField, this.targetClass, e.getMessage(), e.getMessages().get(InvalidNestedMappingException.FIELD));
                }
            } else {
                targetField = ClassesManager.retrieveField(this.targetClass, targetFieldName);
            }
            MappedField configuredMappedField = new MappedField(configuredField);
            MappedField targetMappedField = isNestedMapping ? nestedMappingInfo.getLastNestedMappedField() : new MappedField(targetField);
            MappedField destinationMappedField = this.isDestConfigured ? configuredMappedField : targetMappedField;
            MappedField sourceMappedField = this.isDestConfigured ? targetMappedField : configuredMappedField;
            Field destinationField = this.isDestConfigured ? configuredField : targetField;
            Field field = sourceField = this.isDestConfigured ? targetField : configuredField;
            if (isNestedMapping) {
                this.configReader.loadAccessors(nestedMappingInfo.getLastNestedClass(), configuredMappedField, targetMappedField);
            } else {
                this.configReader.loadAccessors(configuredMappedField, targetMappedField);
            }
            boolean isUndefined = false;
            try {
                isUndefined = this.operationAnalyzer.isUndefined(destinationField, sourceField);
            }
            catch (Exception e) {
                Error.badConversion(destinationField, this.destinationClass, sourceField, this.sourceClass, e.getMessage());
            }
            if (isUndefined) {
                Error.undefinedMapping(destinationField, this.destinationClass, sourceField, this.sourceClass);
            }
            InfoOperation info = this.operationAnalyzer.getInfo();
            OperationType operationType = info.getOperationType();
            AGeneralOperation operation = OperationFactory.getOperation(operationType);
            if (operationType.isBasic()) {
                this.simpleOperations.add((ASimpleOperation)operation);
            }
            if (operationType.isComplex()) {
                this.complexOperations.add(((AComplexOperation)operation).setDestinationClass(this.defineStructure(destinationMappedField.getValue(), sourceMappedField.getValue())));
            }
            if (operationType.isRecursive()) {
                ((ARecursiveOperation)operation).setDynamicMethodsToWrite(dynamicMethodsToWrite).setXml(this.xml).setConfigChosen(GeneralUtility.isNull((Object)info.getConfigChosen()) ? this.configurationChosen : info.getConfigChosen());
            }
            operation.setDestinationField(destinationMappedField).setSourceField(sourceMappedField).setInfoOperation(info).setNestedMappingInfo(nestedMappingInfo);
            boolean isAvoidSet = false;
            boolean isConversion = info.getOperationType().isAConversion();
            if (isConversion) {
                isAvoidSet = this.conversionAnalyzer.getMethod().isAvoidSet();
            }
            if (!isNestedMapping || this.targetClass != this.destinationClass) {
                if (isAvoidSet) {
                    ClassesManager.verifyGetterMethods(this.destinationClass, destinationMappedField);
                } else {
                    ClassesManager.verifiesAccessorMethods(this.destinationClass, destinationMappedField);
                }
            }
            if (!isNestedMapping || this.targetClass != this.sourceClass) {
                ClassesManager.verifyGetterMethods(this.sourceClass, sourceMappedField);
            }
            ClassesManager.findSetterMethods(this.sourceClass, sourceMappedField);
            operation.avoidDestinationSet(isAvoidSet);
            if (!isConversion) continue;
            this.conversionHandler.load(this.conversionAnalyzer).from(sourceMappedField).to(destinationMappedField);
            if (this.conversionHandler.toBeCreated()) {
                dynamicMethodsToWrite.add(this.conversionHandler.loadMethod());
            }
            operation.setConversionMethod(this.conversionHandler.getMethod()).setMemberShip(this.conversionHandler.getMembership());
        }
        if (this.simpleOperations.isEmpty() && this.complexOperations.isEmpty()) {
            Error.absentRelationship(this.configuredClass, this.targetClass);
        }
    }

    private Class<?> defineStructure(Field destination, Field source) {
        Class<?> sourceInterface;
        Class destinationClass = destination.getType();
        Class sourceClass = source.getType();
        Class result = null;
        result = destinationClass.isInterface() ? (sourceClass.isInterface() ? (Class)GeneralUtility.implementationClass.get((Object)destinationClass.getName()) : (destinationClass == (sourceInterface = sourceClass.getInterfaces()[0]) ? sourceClass : (Class)GeneralUtility.implementationClass.get((Object)destinationClass.getName()))) : destinationClass;
        return result;
    }

    public List<ASimpleOperation> getSimpleOperations() {
        return this.simpleOperations;
    }

    public List<AComplexOperation> getComplexOperations() {
        return this.complexOperations;
    }
}

