/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.conversions.implicit.ConversionAnalyzer;
import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;

public final class ArrayAnalyzer
implements IOperationAnalyzer {
    private final XML xml;

    public ArrayAnalyzer(XML aXml) {
        this.xml = aXml;
    }

    public InfoOperation getInfoOperation(Field destination, Field source) {
        Class<?> sComponentType;
        InfoOperation operation = new InfoOperation().setInstructionType(OperationType.ARRAY).setConversionType(ConversionType.UNDEFINED);
        if (destination.getType().isAssignableFrom(source.getType())) {
            return operation.setConversionType(ConversionType.ABSENT);
        }
        Class<?> dComponentType = destination.getType().getComponentType();
        if (ClassesManager.isAssignableFrom(dComponentType, sComponentType = source.getType().getComponentType())) {
            return operation.setConversionType(ConversionType.ABSENT);
        }
        if (GeneralUtility.areBasic(dComponentType, sComponentType)) {
            return operation.setConversionType(ConversionAnalyzer.getConversionType(dComponentType, sComponentType));
        }
        if (ClassesManager.areMappedObjects(dComponentType, sComponentType, this.xml)) {
            return operation.setInstructionType(OperationType.ARRAY_WITH_MAPPED_ITEMS).setConfigChosen(ClassesManager.configChosen(dComponentType, sComponentType, this.xml));
        }
        return operation;
    }

    public boolean verifyConditions(Field destination, Field source) {
        return destination.getType().isArray() && source.getType().isArray();
    }
}

